/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTreeIterator;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SeparatorList<E>
extends TransformedList<E, E> {
    private SeparatorInjectorList<E> separatorSource;
    private static final Object SEPARATOR = Barcode.BLACK;
    private static final Object SOURCE_ELEMENT = Barcode.WHITE;
    private final int minimumSizeForSeparator;
    private Barcode collapsedElements;

    public SeparatorList(EventList<E> eventList, Comparator<? super E> comparator, int n2, int n3) {
        super(new SeparatorInjectorList<E>(new SortedList<E>(eventList, comparator), n3));
        this.separatorSource = (SeparatorInjectorList)this.source;
        this.minimumSizeForSeparator = n2;
        this.rebuildCollapsedElements();
        this.separatorSource.addListEventListener(this);
    }

    private void rebuildCollapsedElements() {
        this.collapsedElements = new Barcode();
        this.collapsedElements.addBlack(0, this.separatorSource.size());
        int n2 = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.colourSize(SEPARATOR);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.updateGroup(i2, n2, false);
        }
    }

    @Override
    public int size() {
        return this.collapsedElements.colourSize(Barcode.BLACK);
    }

    @Override
    protected int getSourceIndex(int n2) {
        return this.collapsedElements.getIndex(n2, Barcode.BLACK);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    public void setComparator(Comparator<E> comparator) {
        boolean bl = this.isEmpty();
        if (!bl) {
            this.updates.beginEvent();
            this.updates.addDelete(0, this.size() - 1);
        }
        SortedList sortedList = (SortedList)this.separatorSource.source;
        sortedList.setComparator(comparator);
        if (!bl) {
            this.rebuildCollapsedElements();
            this.updates.addInsert(0, this.size() - 1);
            this.updates.commitEvent();
        } else {
            ((SeparatorInjectorList)this.separatorSource).grouper.setComparator(comparator);
        }
    }

    private static boolean nextBlackGroup(BarcodeIterator barcodeIterator) {
        if (!barcodeIterator.hasNextWhite()) {
            return false;
        }
        barcodeIterator.nextWhite();
        if (!barcodeIterator.hasNextBlack()) {
            return false;
        }
        barcodeIterator.nextBlack();
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        block19: {
            int n2;
            int n3;
            block17: {
                block18: {
                    Element element;
                    this.updates.beginEvent(true);
                    if (!listEvent.isReordering()) break block17;
                    boolean bl = true;
                    Object object = new SimpleTreeIterator(((SeparatorInjectorList)this.separatorSource).separators);
                    while (((SimpleTreeIterator)object).hasNext()) {
                        ((SimpleTreeIterator)object).next();
                        element = ((SimpleTreeIterator)object).node();
                        int n4 = ((SeparatorInjectorList.GroupSeparator)element.get()).getLimit();
                        if (n4 == 0 || n4 >= this.separatorSource.size() || n4 >= ((SeparatorInjectorList.GroupSeparator)element.get()).size()) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) break block18;
                    object = listEvent.getReorderMap();
                    element = (Element)new int[this.collapsedElements.colourSize(Barcode.BLACK)];
                    BarcodeIterator barcodeIterator = this.collapsedElements.iterator();
                    int n5 = 0;
                    while (true) {
                        int n6;
                        boolean bl2;
                        int n7;
                        if (barcodeIterator.hasNextWhite()) {
                            barcodeIterator.nextWhite();
                            n7 = barcodeIterator.getIndex();
                            bl2 = true;
                            n6 = barcodeIterator.getWhiteIndex();
                        } else {
                            bl2 = false;
                            n7 = this.collapsedElements.size();
                            n6 = this.collapsedElements.whiteSize();
                        }
                        for (int i2 = n5; i2 < n7; ++i2) {
                            element[i2 - n6] = object[i2] - n6;
                        }
                        if (!bl2 || !barcodeIterator.hasNextBlack()) break;
                        barcodeIterator.nextBlack();
                        n5 = barcodeIterator.getIndex();
                    }
                    this.updates.reorder((int[])element);
                    break block19;
                }
                int n8 = this.collapsedElements.colourSize(Barcode.BLACK);
                if (n8 <= 0) break block19;
                this.updates.addDelete(0, n8 - 1);
                this.updates.addInsert(0, n8 - 1);
                break block19;
            }
            int n9 = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.colourSize(SEPARATOR);
            while (listEvent.next()) {
                int n10 = listEvent.getIndex();
                n3 = listEvent.getType();
                if (n3 == 2) {
                    this.collapsedElements.add(n10, Barcode.BLACK, 1);
                    int n11 = this.collapsedElements.getColourIndex(n10, Barcode.BLACK);
                    this.updates.addInsert(n11);
                    continue;
                }
                if (n3 == 1) {
                    if (this.collapsedElements.get(n10) != Barcode.BLACK) continue;
                    int n12 = this.collapsedElements.getColourIndex(n10, Barcode.BLACK);
                    this.updates.addUpdate(n12);
                    continue;
                }
                if (n3 != 0) continue;
                Object object = this.collapsedElements.get(n10);
                if (object == Barcode.BLACK) {
                    n2 = this.collapsedElements.getColourIndex(n10, Barcode.BLACK);
                    this.updates.addDelete(n2);
                }
                this.collapsedElements.remove(n10, 1);
            }
            listEvent.reset();
            BitSet bitSet = new BitSet(n9);
            while (listEvent.nextBlock()) {
                n3 = listEvent.getBlockStartIndex();
                int n13 = listEvent.getBlockEndIndex();
                n2 = listEvent.getType();
                int n14 = n3;
                int n15 = -1;
                int n16 = -1;
                while (n14 <= n13) {
                    switch (n2) {
                        case 1: 
                        case 2: {
                            n15 = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getColourIndex(n14, true, SEPARATOR);
                            break;
                        }
                        case 0: {
                            if (n14 >= ((SeparatorInjectorList)this.separatorSource).insertedSeparators.size()) break;
                            n15 = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getColourIndex(n14, true, SEPARATOR);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("ListEvent Type: " + n2 + " not supported");
                        }
                    }
                    ++n14;
                    if (n16 == n15) continue;
                    n16 = n15;
                    bitSet.set(n16);
                    if (n2 != 1) continue;
                    if (n16 > 0) {
                        bitSet.set(n16 - 1);
                    }
                    if (n16 >= n9 - 1) continue;
                    bitSet.set(n16 + 1);
                }
            }
            n3 = bitSet.nextSetBit(0);
            while (n3 >= 0) {
                this.updateGroup(n3, n9, true);
                if (n3 == Integer.MAX_VALUE) break;
                n3 = bitSet.nextSetBit(n3 + 1);
            }
        }
        this.updates.commitEvent();
    }

    private void updateGroup(int n2, int n3, boolean bl) {
        int n4;
        Separator separator = (Separator)((SeparatorInjectorList)this.separatorSource).separators.get(n2).get();
        int n5 = separator.getLimit();
        int n6 = n2 + 1;
        int n7 = n6 == n3 ? ((SeparatorInjectorList)this.separatorSource).insertedSeparators.size() : ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getIndex(n6, SEPARATOR);
        int n8 = n7 - (n4 = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getIndex(n2, SEPARATOR)) - 1;
        if (n8 < this.minimumSizeForSeparator) {
            this.setVisible(n4, Barcode.WHITE, bl);
            for (int i2 = n4 + 1; i2 < n7; ++i2) {
                this.setVisible(i2, Barcode.BLACK, bl);
            }
        } else {
            this.setVisible(n4, Barcode.BLACK, bl);
            for (int i3 = n4 + 1; i3 < n7; ++i3) {
                boolean bl2 = i3 - n4 <= n5;
                this.setVisible(i3, bl2 ? Barcode.BLACK : Barcode.WHITE, bl);
            }
        }
    }

    private void setVisible(int n2, Object object, boolean bl) {
        Object object2 = this.collapsedElements.get(n2);
        if (object == object2) {
            return;
        }
        if (object == Barcode.WHITE) {
            int n3 = this.collapsedElements.getColourIndex(n2, Barcode.BLACK);
            if (bl) {
                this.updates.addDelete(n3);
            }
            this.collapsedElements.set(n2, Barcode.WHITE, 1);
        } else if (object == Barcode.BLACK) {
            this.collapsedElements.set(n2, Barcode.BLACK, 1);
            int n4 = this.collapsedElements.getColourIndex(n2, Barcode.BLACK);
            if (bl) {
                this.updates.addInsert(n4);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void dispose() {
        this.separatorSource.dispose();
        this.separatorSource.source.dispose();
        super.dispose();
    }

    static class SeparatorInjectorList<E>
    extends TransformedList<E, E> {
        private final Grouper<E> grouper;
        private Barcode insertedSeparators;
        private SimpleTree<GroupSeparator> separators;
        private int defaultLimit;

        public SeparatorInjectorList(SortedList<E> sortedList, int n2) {
            super(sortedList);
            this.defaultLimit = n2;
            GrouperClient grouperClient = new GrouperClient();
            this.grouper = new Grouper<E>(sortedList, grouperClient);
            this.rebuildSeparators();
            sortedList.addListEventListener(this);
        }

        private void rebuildSeparators() {
            this.insertedSeparators = new Barcode();
            this.separators = new SimpleTree();
            this.insertedSeparators.add(0, SOURCE_ELEMENT, this.source.size());
            BarcodeIterator barcodeIterator = this.grouper.getBarcode().iterator();
            while (barcodeIterator.hasNextColour(Grouper.UNIQUE)) {
                barcodeIterator.nextColour(Grouper.UNIQUE);
                int n2 = barcodeIterator.getColourIndex(Grouper.UNIQUE);
                int n3 = barcodeIterator.getIndex();
                this.insertedSeparators.add(n2 + n3, SEPARATOR, 1);
                Element<GroupSeparator> element = this.separators.add(n2, new GroupSeparator(), 1);
                element.get().setNode(element);
                element.get().applyLimit(this.defaultLimit, false);
            }
            for (int i2 = 0; i2 < this.separators.size(); ++i2) {
                this.separators.get(i2).get().updateCachedValues();
            }
        }

        @Override
        public E get(int n2) {
            Object object = this.insertedSeparators.get(n2);
            if (object == SEPARATOR) {
                return (E)this.separators.get(this.getSeparatorIndex(n2)).get();
            }
            if (object == SOURCE_ELEMENT) {
                return this.source.get(this.getSourceIndex(n2));
            }
            throw new IllegalStateException();
        }

        @Override
        protected int getSourceIndex(int n2) {
            Object object = this.insertedSeparators.get(n2);
            if (object == SEPARATOR) {
                throw new IllegalArgumentException("No source index exists for the separator located at index " + n2);
            }
            if (object == SOURCE_ELEMENT) {
                return this.insertedSeparators.getColourIndex(n2, SOURCE_ELEMENT);
            }
            throw new IllegalStateException();
        }

        protected int getSeparatorIndex(int n2) {
            Object object = this.insertedSeparators.get(n2);
            if (object == SEPARATOR) {
                return this.insertedSeparators.getColourIndex(n2, SEPARATOR);
            }
            if (object == SOURCE_ELEMENT) {
                return -1;
            }
            throw new IllegalStateException();
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public int size() {
            return this.insertedSeparators.size();
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            SortedList sortedList = (SortedList)this.source;
            Comparator comparator = sortedList.getComparator();
            if (comparator != this.grouper.getComparator()) {
                this.grouper.setComparator(comparator);
                this.rebuildSeparators();
                return;
            }
            this.updates.beginEvent(true);
            if (listEvent.isReordering()) {
                int[] nArray = listEvent.getReorderMap();
                int[] nArray2 = new int[this.insertedSeparators.size()];
                int n2 = -1;
                int n3 = 0;
                int n4 = -1;
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    int n5;
                    if (i2 == n3) {
                        nArray2[i2 + ++n4] = i2 + n4;
                        n2 = n3;
                        n5 = n4 + 1;
                        int n6 = n3 = n5 < this.separators.size() ? this.separators.get(n5).get().start() : this.insertedSeparators.size();
                    }
                    if ((n5 = nArray[i2]) < n2 || n5 >= n3) {
                        throw new IllegalStateException();
                    }
                    nArray2[i2 + n4 + 1] = n5 + n4 + 1;
                }
                this.updates.reorder(nArray2);
            } else {
                this.grouper.listChanged(listEvent);
            }
            for (int i3 = 0; i3 < this.separators.size(); ++i3) {
                this.separators.get(i3).get().updateCachedValues();
            }
            this.updates.commitEvent();
        }

        class GroupSeparator
        implements Separator<E> {
            private int limit = Integer.MAX_VALUE;
            private int size;
            private E first;
            private Element<GroupSeparator> node = null;

            GroupSeparator() {
            }

            @Override
            public int getLimit() {
                return this.limit;
            }

            @Override
            public void setLimit(int n2) {
                this.applyLimit(n2, true);
            }

            protected void applyLimit(int n2, boolean bl) {
                if (this.limit == n2) {
                    return;
                }
                if (this.node == null) {
                    return;
                }
                this.limit = n2;
                if (bl) {
                    SeparatorInjectorList.this.updates.beginEvent();
                    int n3 = SeparatorInjectorList.this.separators.indexOfNode(this.node, (byte)1);
                    int n4 = SeparatorInjectorList.this.insertedSeparators.getIndex(n3, SEPARATOR);
                    SeparatorInjectorList.this.updates.addUpdate(n4);
                    SeparatorInjectorList.this.updates.commitEvent();
                }
            }

            @Override
            public List<E> getGroup() {
                if (this.node == null) {
                    return Collections.emptyList();
                }
                return SeparatorInjectorList.this.source.subList(this.start(), this.end());
            }

            @Override
            public E first() {
                return this.first;
            }

            @Override
            public int size() {
                return this.size;
            }

            public void setNode(Element<GroupSeparator> element) {
                this.node = element;
            }

            private int start() {
                if (this.node == null) {
                    throw new IllegalStateException();
                }
                int n2 = SeparatorInjectorList.this.separators.indexOfNode(this.node, (byte)1);
                if (n2 == -1) {
                    throw new IllegalStateException();
                }
                int n3 = SeparatorInjectorList.this.insertedSeparators.getIndex(n2, SEPARATOR);
                return n3 - n2;
            }

            private int end() {
                if (this.node == null) {
                    throw new IllegalStateException();
                }
                int n2 = SeparatorInjectorList.this.separators.indexOfNode(this.node, (byte)1) + 1;
                if (n2 == 0) {
                    throw new IllegalStateException();
                }
                int n3 = n2 == SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR) ? SeparatorInjectorList.this.insertedSeparators.size() : SeparatorInjectorList.this.insertedSeparators.getIndex(n2, SEPARATOR);
                return n3 - n2;
            }

            public void updateCachedValues() {
                if (this.node != null) {
                    int n2 = this.start();
                    int n3 = this.end();
                    this.first = SeparatorInjectorList.this.source.get(n2);
                    this.size = n3 - n2;
                } else {
                    this.first = null;
                    this.size = 0;
                }
            }

            public String toString() {
                return "" + this.size() + " elements starting with \"" + this.first() + "\"";
            }
        }

        private class GrouperClient
        implements Grouper.Client<E> {
            private GrouperClient() {
            }

            @Override
            public void groupChanged(int n2, int n3, int n4, boolean bl, int n5, E e2, E e3, boolean bl2, boolean bl3) {
                int n6;
                int n7;
                Element<GroupSeparator> element;
                int n8;
                boolean bl4 = false;
                if (n4 == 2) {
                    n8 = n2 + n3;
                    SeparatorInjectorList.this.insertedSeparators.add(n8, SEPARATOR, 1);
                    SeparatorInjectorList.this.updates.addInsert(n8);
                    element = SeparatorInjectorList.this.separators.add(n3, new GroupSeparator(), 1);
                    element.get().setNode(element);
                    element.get().setLimit(SeparatorInjectorList.this.defaultLimit);
                } else if (n4 == 1) {
                    n3 = Math.min(n3, SeparatorInjectorList.this.insertedSeparators.blackSize() - 1);
                    n8 = SeparatorInjectorList.this.insertedSeparators.getIndex(n3, SEPARATOR);
                    SeparatorInjectorList.this.updates.addUpdate(n8);
                } else if (n4 == 0) {
                    n8 = SeparatorInjectorList.this.insertedSeparators.getIndex(n3, SEPARATOR);
                    SeparatorInjectorList.this.insertedSeparators.remove(n8, 1);
                    SeparatorInjectorList.this.updates.addDelete(n8);
                    element = SeparatorInjectorList.this.separators.get(n3);
                    SeparatorInjectorList.this.separators.remove(element);
                    element.get().setNode(null);
                    element.get().updateCachedValues();
                    --n3;
                }
                if (n5 == 2) {
                    n8 = n2 + n3 + 1;
                    SeparatorInjectorList.this.insertedSeparators.add(n8, SOURCE_ELEMENT, 1);
                    SeparatorInjectorList.this.updates.addInsert(n8);
                } else if (n5 == 1) {
                    int n9;
                    n8 = n2 + n3 + 1;
                    if (n4 == 2 && n3 + 1 < (n9 = SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR)) && (n7 = SeparatorInjectorList.this.insertedSeparators.getIndex(n3 + 1, SEPARATOR)) == n8) {
                        ++n8;
                        bl4 = true;
                    }
                    SeparatorInjectorList.this.updates.addUpdate(n8);
                } else if (n5 == 0) {
                    n8 = n2 + n3 + 1;
                    int n10 = n3;
                    while (SeparatorInjectorList.this.insertedSeparators.get(n8) == SEPARATOR) {
                        this.shiftSeparator(n10++);
                    }
                    SeparatorInjectorList.this.insertedSeparators.remove(n8, 1);
                    SeparatorInjectorList.this.updates.addDelete(n8);
                }
                if (bl4) {
                    n8 = n2 + n3 + 1;
                    assert (n8 == SeparatorInjectorList.this.insertedSeparators.getIndex(n3 + 1, SEPARATOR));
                    SeparatorInjectorList.this.insertedSeparators.remove(n8, 1);
                    SeparatorInjectorList.this.updates.addDelete(n8);
                    SeparatorInjectorList.this.insertedSeparators.add(n8 + 1, SEPARATOR, 1);
                    SeparatorInjectorList.this.updates.addInsert(n8 + 1);
                }
                n8 = n3 + 1;
                if (n4 == 0 && n5 != 2 && n8 < SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR) && n8 < SeparatorInjectorList.this.grouper.getBarcode().colourSize(Grouper.UNIQUE) && bl3 && (n6 = SeparatorInjectorList.this.grouper.getBarcode().getIndex(n8, Grouper.UNIQUE)) + n8 < (n7 = SeparatorInjectorList.this.insertedSeparators.getIndex(n8, SEPARATOR))) {
                    SeparatorInjectorList.this.insertedSeparators.remove(n7, 1);
                    SeparatorInjectorList.this.updates.addDelete(n7);
                    SeparatorInjectorList.this.insertedSeparators.add(n6 + n8, SEPARATOR, 1);
                    SeparatorInjectorList.this.updates.addInsert(n6 + n8);
                }
                if (n4 == 1 && n5 == 1 && n8 < SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR) && n8 < SeparatorInjectorList.this.grouper.getBarcode().colourSize(Grouper.UNIQUE) && bl2) {
                    this.shiftSeparator(n8);
                }
            }

            private void shiftSeparator(int n2) {
                int n3;
                int n4 = SeparatorInjectorList.this.grouper.getBarcode().getIndex(n2, Grouper.UNIQUE);
                int n5 = n4 + n2;
                if (n5 != (n3 = SeparatorInjectorList.this.insertedSeparators.getIndex(n2, SEPARATOR))) {
                    SeparatorInjectorList.this.insertedSeparators.remove(n3, 1);
                    SeparatorInjectorList.this.updates.addDelete(n3);
                    SeparatorInjectorList.this.insertedSeparators.add(n5, SEPARATOR, 1);
                    int n6 = n5 < n3 ? n5 : n5 - 1;
                    SeparatorInjectorList.this.updates.addInsert(n6);
                }
            }
        }
    }

    public static interface Separator<E> {
        public int getLimit();

        public void setLimit(int var1);

        public List<E> getGroup();

        public E first();

        public int size();
    }
}

