/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;

public class RangeList<E>
extends TransformedList<E, E> {
    private int desiredStart = 0;
    private int desiredEnd = -1;
    private int currentStartIndex = 0;
    private int currentEndIndex;

    public RangeList(EventList<E> eventList) {
        super(eventList);
        this.currentEndIndex = eventList.size();
        eventList.addListEventListener(this);
    }

    @Override
    public final void listChanged(ListEvent<E> listEvent) {
        this.updates.beginEvent(true);
        while (listEvent.next()) {
            int n2 = listEvent.getType();
            int n3 = listEvent.getIndex();
            E e2 = listEvent.getOldValue();
            E e3 = listEvent.getNewValue();
            if (n2 == 0) {
                if (n3 < this.currentStartIndex) {
                    --this.currentStartIndex;
                    --this.currentEndIndex;
                    continue;
                }
                if (n3 >= this.currentEndIndex) continue;
                --this.currentEndIndex;
                this.updates.elementDeleted(n3 - this.currentStartIndex, e2);
                continue;
            }
            if (n2 == 2) {
                if (n3 < this.currentStartIndex) {
                    ++this.currentStartIndex;
                    ++this.currentEndIndex;
                    continue;
                }
                if (n3 >= this.currentEndIndex) continue;
                ++this.currentEndIndex;
                this.updates.elementInserted(n3 - this.currentStartIndex, e3);
                continue;
            }
            if (n2 != 1 || n3 < this.currentStartIndex || n3 >= this.currentEndIndex) continue;
            this.updates.elementUpdated(n3 - this.currentStartIndex, e2, e3);
        }
        this.adjustRange();
        this.updates.commitEvent();
    }

    @Deprecated
    public void setRange(int n2, int n3) {
        this.setHeadRange(n2, n3);
    }

    public void setHeadRange(int n2, int n3) {
        this.desiredStart = n2;
        this.desiredEnd = n3;
        this.adjustRange();
    }

    public void setMiddleRange(int n2, int n3) {
        this.desiredStart = n2;
        this.desiredEnd = -n3 - 1;
        this.adjustRange();
    }

    public void setTailRange(int n2, int n3) {
        this.desiredStart = -n2 - 1;
        this.desiredEnd = -n3 - 1;
        this.adjustRange();
    }

    protected final void adjustRange() {
        int n2;
        this.updates.beginEvent(true);
        int n3 = this.getStartIndex();
        int n4 = this.getEndIndex();
        if (n4 < n3) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        if (n3 < this.currentStartIndex) {
            this.updates.addInsert(0, this.currentStartIndex - n3 - 1);
        } else if (this.currentStartIndex < n3 && this.currentStartIndex < this.currentEndIndex) {
            n2 = Math.min(n3, this.currentEndIndex);
            for (int i2 = this.currentStartIndex; i2 < n2; ++i2) {
                this.updates.elementDeleted(0, this.source.get(i2));
            }
        }
        this.currentStartIndex = n3;
        if (n4 < this.currentEndIndex) {
            for (n2 = n4; n2 < this.currentEndIndex; ++n2) {
                this.updates.elementDeleted(n4 - this.currentStartIndex, this.source.get(n2));
            }
        } else if (this.currentEndIndex < n4 && n3 < n4) {
            n2 = Math.max(this.currentEndIndex, this.currentStartIndex);
            this.updates.addInsert(n2 - this.currentStartIndex, n4 - this.currentStartIndex - 1);
        }
        this.currentEndIndex = n4;
        this.updates.commitEvent();
    }

    @Override
    public final int size() {
        return this.currentEndIndex - this.currentStartIndex;
    }

    @Override
    protected final int getSourceIndex(int n2) {
        return n2 + this.currentStartIndex;
    }

    @Override
    protected final boolean isWritable() {
        return true;
    }

    public int getStartIndex() {
        int n2;
        int n3 = n2 = this.desiredStart >= 0 ? this.desiredStart : this.source.size() + this.desiredStart + 1;
        if (n2 < 0) {
            return 0;
        }
        if (n2 > this.source.size()) {
            return this.source.size();
        }
        return n2;
    }

    public int getEndIndex() {
        int n2;
        int n3 = this.desiredEnd >= 0 ? this.desiredEnd : this.source.size() + this.desiredEnd + 1;
        if (n3 < (n2 = this.getStartIndex())) {
            return n2;
        }
        if (n3 > this.source.size()) {
            return this.source.size();
        }
        return n3;
    }
}

