/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.Comparator;

public final class PopularityList<E>
extends TransformedList<E, E> {
    private UniqueList<E> uniqueList;

    public static <E extends Comparable<? super E>> PopularityList<E> create(EventList<E> eventList) {
        return new PopularityList<E>(UniqueList.create(eventList));
    }

    public PopularityList(EventList<E> eventList) {
        this(new UniqueList<E>(eventList));
    }

    public PopularityList(EventList<E> eventList, Comparator<E> comparator) {
        this(new UniqueList<E>(eventList, comparator));
    }

    private PopularityList(UniqueList<E> uniqueList) {
        super(new SortedList<E>(uniqueList, new PopularityComparator<E>(uniqueList)));
        this.uniqueList = uniqueList;
        this.source.addListEventListener(this);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updates.forwardEvent(listEvent);
    }

    @Override
    public void dispose() {
        SortedList sortedList = (SortedList)this.source;
        super.dispose();
        sortedList.dispose();
        this.uniqueList.dispose();
    }

    private static class PopularityComparator<E>
    implements Comparator<E> {
        private UniqueList<E> target;

        public PopularityComparator(UniqueList<E> uniqueList) {
            this.target = uniqueList;
        }

        @Override
        public int compare(E e2, E e3) {
            int n2 = this.target.getCount(e2);
            int n3 = this.target.getCount(e3);
            return n3 - n2;
        }
    }
}

