/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;

public class PluggableList<E>
extends TransformedList<E, E> {
    public PluggableList(ListEventPublisher listEventPublisher, ReadWriteLock readWriteLock) {
        this((EventList<E>)new BasicEventList(listEventPublisher, readWriteLock));
    }

    public PluggableList(EventList<E> eventList) {
        super(eventList);
        eventList.addListEventListener(this);
    }

    public EventList<E> createSourceList() {
        return new BasicEventList(this.getPublisher(), this.getReadWriteLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(EventList<E> eventList) {
        this.getReadWriteLock().writeLock().lock();
        try {
            int n2;
            if (this.source == null) {
                throw new IllegalStateException("setSource may not be called on a disposed PluggableList");
            }
            if (eventList == null) {
                throw new IllegalArgumentException("source may not be null");
            }
            if (!this.getReadWriteLock().equals(eventList.getReadWriteLock())) {
                throw new IllegalArgumentException("source list must share lock with PluggableList");
            }
            if (!this.getPublisher().equals(eventList.getPublisher())) {
                throw new IllegalArgumentException("source list must share publisher with PluggableList");
            }
            if (this.source == eventList) {
                return;
            }
            this.updates.beginEvent();
            int n3 = this.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.updates.elementDeleted(0, this.get(n2));
            }
            this.source.removeListEventListener(this);
            this.source = eventList;
            this.source.addListEventListener(this);
            n3 = this.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.updates.elementInserted(n2, this.get(n2));
            }
            this.updates.commitEvent();
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updates.forwardEvent(listEvent);
    }

    @Override
    public void dispose() {
        if (this.source != null) {
            this.source.removeListEventListener(this);
        }
        this.source = null;
    }
}

