/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ObservableElementChangeHandler;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class ObservableElementList<E>
extends TransformedList<E, E>
implements ObservableElementChangeHandler<E> {
    private List<E> observedElements;
    private Connector<? super E> elementConnector = null;
    private boolean singleListenerMode = true;
    private List<EventListener> multiEventListenerRegistry = null;
    private EventListener singleEventListener = null;
    private Barcode singleEventListenerRegistry = null;

    public ObservableElementList(EventList<E> eventList, Connector<? super E> connector) {
        super(eventList);
        this.elementConnector = connector;
        this.elementConnector.setObservableElementList(this);
        this.observedElements = new ArrayList<E>(eventList);
        this.singleEventListenerRegistry = new Barcode();
        this.singleEventListenerRegistry.addWhite(0, eventList.size());
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            EventListener eventListener = this.connectElement(this.get(i2));
            this.registerListener(i2, eventListener, false);
        }
        eventList.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        if (this.observedElements == null) {
            throw new IllegalStateException("This list has been disposed and can no longer be used.");
        }
        while (listEvent.next()) {
            EventListener eventListener;
            Object object;
            Object e2;
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 2) {
                e2 = this.get(n2);
                this.observedElements.add(n2, e2);
                object = this.connectElement(e2);
                this.registerListener(n2, (EventListener)object, false);
                continue;
            }
            if (n3 == 0) {
                e2 = listEvent.getOldValue();
                object = this.observedElements.remove(n2);
                if (e2 == ListEvent.UNKNOWN_VALUE) {
                    e2 = object;
                }
                eventListener = this.unregisterListener(n2);
                this.disconnectElement(e2, eventListener);
                continue;
            }
            if (n3 != 1) continue;
            e2 = listEvent.getOldValue();
            if (e2 == ListEvent.UNKNOWN_VALUE) {
                e2 = this.observedElements.get(n2);
            }
            if ((object = this.get(n2)) == e2) continue;
            this.observedElements.set(n2, object);
            this.disconnectElement(e2, this.getListener(n2));
            eventListener = this.connectElement(object);
            this.registerListener(n2, eventListener, true);
        }
        listEvent.reset();
        this.updates.forwardEvent(listEvent);
    }

    private void registerListener(int n2, EventListener eventListener, boolean bl) {
        if (bl) {
            if (this.singleListenerMode) {
                this.singleEventListenerRegistry.set(n2, eventListener == null ? Barcode.WHITE : Barcode.BLACK, 1);
            } else {
                this.multiEventListenerRegistry.set(n2, eventListener);
            }
        } else if (this.singleListenerMode) {
            this.singleEventListenerRegistry.add(n2, eventListener == null ? Barcode.WHITE : Barcode.BLACK, 1);
        } else {
            this.multiEventListenerRegistry.add(n2, eventListener);
        }
    }

    private EventListener getListener(int n2) {
        EventListener eventListener = null;
        if (this.singleListenerMode) {
            if (this.singleEventListenerRegistry.get(n2) == Barcode.BLACK) {
                eventListener = this.singleEventListener;
            }
        } else {
            eventListener = this.multiEventListenerRegistry.get(n2);
        }
        return eventListener;
    }

    private EventListener unregisterListener(int n2) {
        EventListener eventListener = null;
        if (this.singleListenerMode) {
            if (this.singleEventListenerRegistry.get(n2) == Barcode.BLACK) {
                eventListener = this.singleEventListener;
            }
            this.singleEventListenerRegistry.remove(n2, 1);
        } else {
            eventListener = this.multiEventListenerRegistry.remove(n2);
        }
        return eventListener;
    }

    private EventListener connectElement(E e2) {
        if (e2 == null) {
            return null;
        }
        EventListener eventListener = this.elementConnector.installListener(e2);
        if (this.singleListenerMode && eventListener != null) {
            if (this.singleEventListener == null) {
                this.singleEventListener = eventListener;
            } else if (eventListener != this.singleEventListener) {
                this.switchToMultiListenerMode();
            }
        }
        return eventListener;
    }

    private void disconnectElement(E e2, EventListener eventListener) {
        if (e2 != null && eventListener != null) {
            this.elementConnector.uninstallListener(e2, eventListener);
        }
    }

    private void switchToMultiListenerMode() {
        if (!this.singleListenerMode) {
            throw new IllegalStateException();
        }
        this.multiEventListenerRegistry = new ArrayList<EventListener>(this.source.size());
        for (int i2 = 0; i2 < this.source.size(); ++i2) {
            this.multiEventListenerRegistry.add(null);
        }
        BarcodeIterator barcodeIterator = this.singleEventListenerRegistry.iterator();
        while (barcodeIterator.hasNextBlack()) {
            barcodeIterator.nextBlack();
            this.multiEventListenerRegistry.set(barcodeIterator.getIndex(), this.singleEventListener);
        }
        this.singleEventListener = null;
        this.singleEventListenerRegistry = null;
        this.singleListenerMode = false;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        int n2 = this.observedElements.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            E e2 = this.observedElements.get(i2);
            EventListener eventListener = this.getListener(i2);
            this.disconnectElement(e2, eventListener);
        }
        this.elementConnector.setObservableElementList(null);
        this.observedElements = null;
        this.multiEventListenerRegistry = null;
        this.singleEventListener = null;
        this.singleEventListenerRegistry = null;
        this.elementConnector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void elementChanged(Object object) {
        if (this.observedElements == null) {
            throw new IllegalStateException("This list has been disposed and can no longer be used.");
        }
        this.getReadWriteLock().writeLock().lock();
        try {
            this.updates.beginEvent();
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object e2 = this.get(i2);
                if (object != e2) continue;
                this.updates.elementUpdated(i2, e2);
            }
            this.updates.commitEvent();
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    public static interface Connector<E> {
        public EventListener installListener(E var1);

        public void uninstallListener(E var1, EventListener var2);

        public void setObservableElementList(ObservableElementChangeHandler<? extends E> var1);
    }
}

