/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListSelection<E>
implements ListEventListener<E> {
    public static final int SINGLE_SELECTION = 0;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    public static final int MULTIPLE_INTERVAL_SELECTION_DEFENSIVE = 103;
    private static final Object SELECTED = Barcode.BLACK;
    private static final Object DESELECTED = Barcode.WHITE;
    private final EventList<E> source;
    private SelectedList<E> selectedList;
    private DeselectedList<E> deselectedList;
    private SelectionToggleList<E> selectedToggleList;
    private DeselectionToggleList<E> deselectedToggleList;
    private Barcode barcode = new Barcode();
    private int leadSelectionIndex = -1;
    private int anchorSelectionIndex = -1;
    private int selectionMode = 103;
    private final Collection<Matcher<E>> validSelectionMatchers = new ArrayList<Matcher<E>>();
    private final CopyOnWriteArrayList<Listener> selectionListeners = new CopyOnWriteArrayList();

    public ListSelection(EventList<E> eventList) {
        this.source = eventList;
        this.barcode.add(0, DESELECTED, eventList.size());
        eventList.addListEventListener(this);
    }

    public ListSelection(EventList<E> eventList, int[] nArray) {
        this(eventList);
        this.select(nArray);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        int n2 = this.getMinSelectionIndex();
        int n3 = this.getMaxSelectionIndex();
        boolean bl = false;
        if (listEvent.isReordering()) {
            this.beginSelected();
            int[] nArray = listEvent.getReorderMap();
            int[] nArray2 = new int[this.barcode.colourSize(SELECTED)];
            int[] nArray3 = new int[this.barcode.colourSize(DESELECTED)];
            Barcode barcode = this.barcode;
            this.barcode = new Barcode();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n4;
                int n5;
                Object object = barcode.get(nArray[i2]);
                boolean bl2 = object != DESELECTED;
                this.barcode.add(i2, object, 1);
                if (bl2) {
                    n5 = barcode.getColourIndex(nArray[i2], SELECTED);
                    n4 = this.barcode.getColourIndex(i2, SELECTED);
                    nArray2[n4] = n5;
                    continue;
                }
                n5 = barcode.getColourIndex(nArray[i2], DESELECTED);
                n4 = this.barcode.getColourIndex(i2, DESELECTED);
                nArray3[n4] = n5;
            }
            this.anchorSelectionIndex = -1;
            this.leadSelectionIndex = -1;
            this.addSelectedReorder(nArray2);
            this.commitSelected();
            this.beginDeselected();
            this.addDeselectedReorder(nArray3);
            this.commitDeselected();
            bl = true;
        } else {
            this.beginAll();
            while (listEvent.next()) {
                int n6;
                boolean bl3;
                int n7 = listEvent.getIndex();
                int n8 = listEvent.getType();
                int n9 = this.barcode.getColourIndex(n7, SELECTED);
                boolean bl4 = bl3 = n9 != -1;
                if (n8 == 0) {
                    if (n7 <= n3) {
                        bl = true;
                    }
                    if (bl3) {
                        this.barcode.remove(n7, 1);
                        this.addSelectedDelete(n9, listEvent.getOldValue());
                    } else {
                        n6 = this.barcode.getColourIndex(n7, DESELECTED);
                        this.addDeselectedDelete(n6, listEvent.getOldValue());
                        this.barcode.remove(n7, 1);
                    }
                } else if (n8 == 2) {
                    if (n7 <= n3) {
                        bl = true;
                    }
                    if (bl3) {
                        if (this.selectionMode == 1 || this.selectionMode == 2) {
                            this.barcode.add(n7, SELECTED, 1);
                            this.addSelectedInsert(n9, listEvent.getNewValue());
                        } else {
                            this.barcode.add(n7, DESELECTED, 1);
                            n6 = this.barcode.getColourIndex(n7, DESELECTED);
                            this.addDeselectedInsert(n6, listEvent.getNewValue());
                        }
                    } else {
                        this.barcode.add(n7, DESELECTED, 1);
                        n6 = this.barcode.getColourIndex(n7, DESELECTED);
                        this.addDeselectedInsert(n6, listEvent.getNewValue());
                    }
                } else if (n8 == 1) {
                    if (bl3) {
                        this.addSelectedUpdate(n9, listEvent.getOldValue(), listEvent.getNewValue());
                    } else {
                        n6 = this.barcode.getColourIndex(n7, DESELECTED);
                        this.addDeselectedUpdate(n6, listEvent.getOldValue(), listEvent.getNewValue());
                    }
                }
                this.anchorSelectionIndex = this.adjustIndex(this.anchorSelectionIndex, n8, n7);
                this.leadSelectionIndex = this.adjustIndex(this.leadSelectionIndex, n8, n7);
            }
            this.commitAll();
        }
        if (n2 != -1 && n3 != -1 && bl) {
            int n10 = this.getMinSelectionIndex();
            int n11 = this.getMaxSelectionIndex();
            int n12 = n2;
            int n13 = n3;
            if (n10 != -1 && n10 < n12) {
                n12 = n10;
            }
            if (n11 != -1 && n11 > n13) {
                n13 = n11;
            }
            this.fireSelectionChanged(n12, n13);
        }
    }

    public void addValidSelectionMatcher(Matcher<E> matcher) {
        this.validSelectionMatchers.add(matcher);
        int n2 = this.getMaxSelectionIndex();
        for (int i2 = this.getMinSelectionIndex(); i2 <= n2; ++i2) {
            if (!this.isSelected(i2) || this.isSelectable(i2)) continue;
            this.deselect(i2);
        }
    }

    public void removeValidSelectionMatcher(Matcher<E> matcher) {
        this.validSelectionMatchers.remove(matcher);
    }

    private int adjustIndex(int n2, int n3, int n4) {
        if (n2 == -1) {
            return -1;
        }
        if (n3 == 0) {
            if (n4 < n2) {
                return n2 - 1;
            }
            if (n4 == n2) {
                return -1;
            }
            return n2;
        }
        if (n3 == 1) {
            return n2;
        }
        if (n3 == 2) {
            if (n4 <= n2) {
                return n2 + 1;
            }
            return n2;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getSelected() {
        CopyOnWriteArrayList<Listener> copyOnWriteArrayList = this.selectionListeners;
        synchronized (copyOnWriteArrayList) {
            if (this.selectedList == null) {
                this.selectedList = new SelectedList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.selectedList, this);
            }
        }
        return this.selectedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingSelected() {
        CopyOnWriteArrayList<Listener> copyOnWriteArrayList = this.selectionListeners;
        synchronized (copyOnWriteArrayList) {
            if (this.selectedToggleList == null) {
                this.selectedToggleList = new SelectionToggleList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.selectedToggleList, this);
            }
        }
        return this.selectedToggleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getDeselected() {
        CopyOnWriteArrayList<Listener> copyOnWriteArrayList = this.selectionListeners;
        synchronized (copyOnWriteArrayList) {
            if (this.deselectedList == null) {
                this.deselectedList = new DeselectedList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.deselectedList, this);
            }
        }
        return this.deselectedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingDeselected() {
        CopyOnWriteArrayList<Listener> copyOnWriteArrayList = this.selectionListeners;
        synchronized (copyOnWriteArrayList) {
            if (this.deselectedToggleList == null) {
                this.deselectedToggleList = new DeselectionToggleList<E>(this.source);
                this.source.getPublisher().setRelatedListener(this.deselectedToggleList, this);
            }
        }
        return this.deselectedToggleList;
    }

    public EventList<E> getSource() {
        return this.source;
    }

    public void invertSelection() {
        this.anchorSelectionIndex = -1;
        this.leadSelectionIndex = -1;
        this.beginAll();
        BarcodeIterator barcodeIterator = this.barcode.iterator();
        while (barcodeIterator.hasNext()) {
            int n2;
            Object object = barcodeIterator.next();
            Object e2 = this.source.get(barcodeIterator.getIndex());
            int n3 = barcodeIterator.getColourIndex(object);
            if (object == SELECTED) {
                barcodeIterator.set(DESELECTED);
                n2 = barcodeIterator.getColourIndex(DESELECTED);
                this.addDeselectEvent(n3, n2, e2);
                continue;
            }
            barcodeIterator.set(SELECTED);
            n2 = barcodeIterator.getColourIndex(SELECTED);
            this.addSelectEvent(n2, n3, e2);
        }
        this.commitAll();
        this.fireSelectionChanged(0, this.source.size() - 1);
    }

    public boolean isSelected(int n2) {
        if (n2 < 0 || n2 >= this.source.size()) {
            return false;
        }
        return this.barcode.getColourIndex(n2, SELECTED) != -1;
    }

    public void deselect(int n2) {
        this.deselect(n2, n2);
    }

    public void deselect(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            int n4 = this.getMaxSelectionIndex();
            if (n4 >= n2 && n4 <= n3) {
                this.deselectAll();
            }
            return;
        }
        if (this.selectionMode == 1 && n2 > this.getMinSelectionIndex()) {
            n3 = Math.max(n3, this.getMaxSelectionIndex());
        }
        int n5 = this.anchorSelectionIndex == n2 ? -1 : this.anchorSelectionIndex;
        int n6 = this.leadSelectionIndex == n3 ? -1 : this.leadSelectionIndex;
        this.anchorSelectionIndex = n2;
        this.leadSelectionIndex = n3;
        this.setSubRangeOfRange(false, n2, n3, -1, -1, n6, n5);
    }

    public void deselect(int[] nArray) {
        int n2 = -1;
        int n3 = -1;
        this.beginAll();
        int n4 = 0;
        BarcodeIterator barcodeIterator = this.barcode.iterator();
        while (barcodeIterator.hasNext() && n4 != nArray.length) {
            Object object = barcodeIterator.next();
            if (barcodeIterator.getIndex() != nArray[n4]) continue;
            if (object == SELECTED) {
                if (n2 == -1) {
                    n2 = barcodeIterator.getIndex();
                }
                n3 = barcodeIterator.getIndex();
                this.addDeselectEvent(barcodeIterator);
            }
            ++n4;
        }
        this.commitAll();
        if (n2 > -1) {
            this.fireSelectionChanged(n2, n3);
        }
    }

    public void deselectAll() {
        this.setAllColor(DESELECTED);
    }

    private void setAllColor(Object object) {
        Object object2;
        Object object3 = object2 = object == SELECTED ? DESELECTED : SELECTED;
        if (this.barcode.colourSize(object2) == 0) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        this.beginAll();
        BarcodeIterator barcodeIterator = this.barcode.iterator();
        while (barcodeIterator.hasNextColour(object2)) {
            barcodeIterator.nextColour(object2);
            int n4 = barcodeIterator.getIndex();
            Object e2 = this.source.get(n4);
            if (object == SELECTED) {
                this.addDeselectedDelete(0, e2);
                this.addSelectedInsert(n4, e2);
            } else {
                this.addSelectedDelete(0, e2);
                this.addDeselectedInsert(n4, e2);
            }
            if (n2 == -1) {
                n2 = n4;
            }
            n3 = n4;
        }
        this.barcode.clear();
        this.barcode.add(0, object, this.source.size());
        this.commitAll();
        this.fireSelectionChanged(n2, n3);
    }

    public void select(int n2) {
        this.select(n2, n2);
    }

    public void select(int n2, int n3) {
        int n4;
        int n5;
        if (n2 == -1 || n3 == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelection(n2);
            return;
        }
        if (this.selectionMode == 1) {
            n5 = 0;
            n4 = this.getMinSelectionIndex();
            int n6 = this.getMaxSelectionIndex();
            if (n4 - 1 <= n2 && n2 <= n6 + 1) {
                n5 = 1;
            }
            if (n4 - 1 <= n3 && n3 <= n6 + 1) {
                n5 = 1;
            }
            if (n5 == 0) {
                this.setSelection(n2, n3);
                return;
            }
        }
        n5 = this.anchorSelectionIndex == n2 ? -1 : this.anchorSelectionIndex;
        n4 = this.leadSelectionIndex == n3 ? -1 : this.leadSelectionIndex;
        this.anchorSelectionIndex = n2;
        this.leadSelectionIndex = n3;
        this.setSubRangeOfRange(true, n2, n3, -1, -1, n4, n5);
    }

    public void select(int[] nArray) {
        int n2 = -1;
        int n3 = -1;
        this.beginAll();
        int n4 = 0;
        BarcodeIterator barcodeIterator = this.barcode.iterator();
        while (barcodeIterator.hasNext() && n4 != nArray.length) {
            Object object = barcodeIterator.next();
            if (barcodeIterator.getIndex() != nArray[n4]) continue;
            if (object != SELECTED) {
                if (n2 == -1) {
                    n2 = barcodeIterator.getIndex();
                }
                n3 = barcodeIterator.getIndex();
                this.addSelectEvent(barcodeIterator);
            }
            ++n4;
        }
        this.commitAll();
        if (n2 > -1) {
            this.fireSelectionChanged(n2, n3);
        }
    }

    public int select(E e2) {
        int n2 = this.source.indexOf(e2);
        if (n2 != -1) {
            this.select(n2);
        }
        return n2;
    }

    public boolean select(Collection<E> collection) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (E e2 : collection) {
            int n2 = this.source.indexOf(e2);
            if (n2 == -1) continue;
            treeSet.add(new Integer(n2));
        }
        if (treeSet.isEmpty()) {
            return false;
        }
        Object object = new int[treeSet.size()];
        int n3 = 0;
        for (Integer n4 : treeSet) {
            object[n3] = n4;
            ++n3;
        }
        int n5 = this.getSelected().size();
        this.select((int[])object);
        int n6 = this.getSelected().size();
        return n6 > n5;
    }

    public void selectAll() {
        this.setAllColor(SELECTED);
    }

    public void setSelection(int n2) {
        this.setSelection(n2, n2);
    }

    public void setSelection(int n2, int n3) {
        if (n2 == -1 || n3 == -1) {
            this.deselectAll();
            return;
        }
        if (this.selectionMode == 0) {
            n3 = n2;
        }
        int n4 = this.anchorSelectionIndex == n2 ? -1 : this.anchorSelectionIndex;
        int n5 = this.leadSelectionIndex == n3 ? -1 : this.leadSelectionIndex;
        this.anchorSelectionIndex = n2;
        this.leadSelectionIndex = n3;
        this.setSubRangeOfRange(true, n2, n3, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), n5, n4);
    }

    public void setSelection(int[] nArray) {
        if (nArray.length == 0) {
            this.deselectAll();
            return;
        }
        int n2 = -1;
        int n3 = -1;
        this.beginAll();
        int n4 = 0;
        BarcodeIterator barcodeIterator = this.barcode.iterator();
        while (barcodeIterator.hasNext()) {
            Object object = barcodeIterator.next();
            if (barcodeIterator.getIndex() == nArray[n4]) {
                if (object != SELECTED) {
                    if (n2 == -1) {
                        n2 = barcodeIterator.getIndex();
                    }
                    n3 = barcodeIterator.getIndex();
                    this.addSelectEvent(barcodeIterator);
                }
                if (n4 >= nArray.length - 1) continue;
                ++n4;
                continue;
            }
            if (object != SELECTED) continue;
            if (n2 == -1) {
                n2 = barcodeIterator.getIndex();
            }
            n3 = barcodeIterator.getIndex();
            this.addDeselectEvent(barcodeIterator);
        }
        this.commitAll();
        if (n2 > -1) {
            this.fireSelectionChanged(n2, n3);
        }
    }

    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    public void setAnchorSelectionIndex(int n2) {
        int n3 = this.anchorSelectionIndex == n2 ? -1 : n2;
        this.anchorSelectionIndex = n2;
        if (n2 == -1 || this.leadSelectionIndex == -1) {
            this.deselectAll();
        } else if (this.selectionMode == 0) {
            this.setSubRangeOfRange(true, n2, n2, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), -1, n3);
        } else if (this.selectionMode == 1) {
            this.setSubRangeOfRange(true, n2, this.leadSelectionIndex, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), -1, n3);
        } else {
            this.setSubRangeOfRange(true, n2, this.leadSelectionIndex, -1, -1, -1, n3);
        }
    }

    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    public void setLeadSelectionIndex(int n2) {
        int n3 = this.leadSelectionIndex == n2 ? -1 : n2;
        int n4 = this.leadSelectionIndex;
        this.leadSelectionIndex = n2;
        if (n2 == -1 || this.anchorSelectionIndex == -1) {
            this.deselectAll();
        } else if (this.selectionMode == 0) {
            this.setSubRangeOfRange(true, n2, n2, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), n3, -1);
        } else if (this.selectionMode == 1) {
            this.setSubRangeOfRange(true, this.anchorSelectionIndex, n2, this.getMinSelectionIndex(), this.getMaxSelectionIndex(), n3, -1);
        } else {
            this.setSubRangeOfRange(true, this.anchorSelectionIndex, n2, this.anchorSelectionIndex, n4, n3, -1);
        }
    }

    private void addSelectedReorder(int[] nArray) {
        if (this.selectedList != null) {
            this.selectedList.updates().reorder(nArray);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().reorder(nArray);
        }
    }

    private void addDeselectedReorder(int[] nArray) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().reorder(nArray);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().reorder(nArray);
        }
    }

    private void addSelectEvent(BarcodeIterator barcodeIterator) {
        Object e2 = this.source.get(barcodeIterator.getIndex());
        int n2 = barcodeIterator.getColourIndex(DESELECTED);
        int n3 = barcodeIterator.set(SELECTED);
        this.addSelectEvent(n3, n2, e2);
    }

    private void addSelectEvent(int n2, int n3, E e2) {
        this.addDeselectedDelete(n3, e2);
        this.addSelectedInsert(n2, e2);
    }

    private void addDeselectEvent(BarcodeIterator barcodeIterator) {
        Object e2 = this.source.get(barcodeIterator.getIndex());
        int n2 = barcodeIterator.getColourIndex(SELECTED);
        int n3 = barcodeIterator.set(DESELECTED);
        this.addDeselectEvent(n2, n3, e2);
    }

    private void addDeselectEvent(int n2, int n3, E e2) {
        this.addSelectedDelete(n2, e2);
        this.addDeselectedInsert(n3, e2);
    }

    private void addSelectedInsert(int n2, E e2) {
        if (this.selectedList != null) {
            this.selectedList.updates().elementInserted(n2, e2);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().elementInserted(n2, e2);
        }
    }

    private void addSelectedUpdate(int n2, E e2, E e3) {
        if (this.selectedList != null) {
            this.selectedList.updates().elementUpdated(n2, e2, e3);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().elementUpdated(n2, e2, e3);
        }
    }

    private void addSelectedDelete(int n2, E e2) {
        if (this.selectedList != null) {
            this.selectedList.updates().elementDeleted(n2, e2);
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().elementDeleted(n2, e2);
        }
    }

    private void addDeselectedInsert(int n2, E e2) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().elementInserted(n2, e2);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().elementInserted(n2, e2);
        }
    }

    private void addDeselectedDelete(int n2, E e2) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().elementDeleted(n2, e2);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().elementDeleted(n2, e2);
        }
    }

    private void addDeselectedUpdate(int n2, E e2, E e3) {
        if (this.deselectedList != null) {
            this.deselectedList.updates().elementUpdated(n2, e2, e3);
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().elementUpdated(n2, e2, e3);
        }
    }

    private void beginAll() {
        this.beginSelected();
        this.beginDeselected();
    }

    private void commitAll() {
        this.commitSelected();
        this.commitDeselected();
    }

    private void beginSelected() {
        if (this.selectedList != null) {
            this.selectedList.updates().beginEvent();
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().beginEvent();
        }
    }

    private void commitSelected() {
        if (this.selectedList != null) {
            this.selectedList.updates().commitEvent();
        }
        if (this.selectedToggleList != null) {
            this.selectedToggleList.updates().commitEvent();
        }
    }

    private void beginDeselected() {
        if (this.deselectedList != null) {
            this.deselectedList.updates().beginEvent();
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().beginEvent();
        }
    }

    private void commitDeselected() {
        if (this.deselectedList != null) {
            this.deselectedList.updates().commitEvent();
        }
        if (this.deselectedToggleList != null) {
            this.deselectedToggleList.updates().commitEvent();
        }
    }

    public void setSelectionMode(int n2) {
        this.selectionMode = n2;
        this.setSelection(this.getMinSelectionIndex(), this.getMaxSelectionIndex());
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public int getMinSelectionIndex() {
        if (this.barcode.colourSize(SELECTED) == 0) {
            return -1;
        }
        return this.barcode.getIndex(0, SELECTED);
    }

    public int getMaxSelectionIndex() {
        if (this.barcode.colourSize(SELECTED) == 0) {
            return -1;
        }
        return this.barcode.getIndex(this.barcode.colourSize(SELECTED) - 1, SELECTED);
    }

    private void setSubRangeOfRange(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 >= this.source.size() || n3 >= this.source.size() || (n2 == -1 || n3 == -1) && n2 != n3) {
            throw new IndexOutOfBoundsException("Invalid range for selection: " + n2 + "-" + n3 + ", list size is " + this.source.size());
        }
        if (n4 >= this.source.size() || n5 >= this.source.size() || (n4 == -1 || n5 == -1) && n4 != n5) {
            throw new IndexOutOfBoundsException("Invalid range for invert selection: " + n4 + "-" + n5 + ", list size is " + this.source.size());
        }
        if (n2 == -1 && n3 == -1) {
            if (n4 == -1 && n5 == -1) {
                return;
            }
            n2 = n4;
            n3 = n5;
            boolean bl2 = bl = !bl;
        }
        if (n4 == -1 && n5 == -1) {
            n4 = n2;
            n5 = n3;
        }
        int n8 = Math.min(n2, n3);
        int n9 = Math.max(n2, n3);
        int n10 = Math.min(n4, n5);
        int n11 = Math.max(n4, n5);
        int n12 = Math.min(n8, n10);
        int n13 = Math.max(n9, n11);
        int n14 = n13 + 1;
        int n15 = n12 - 1;
        this.beginAll();
        for (int i2 = n12; i2 <= n13; ++i2) {
            boolean bl3;
            int n16 = this.barcode.getColourIndex(i2, SELECTED);
            boolean bl4 = n16 != -1;
            boolean bl5 = i2 >= n8 && i2 <= n9;
            boolean bl6 = bl3 = bl5 == bl && this.isSelectable(i2);
            if (bl4 == bl3) continue;
            Object e2 = this.source.get(i2);
            if (i2 < n14) {
                n14 = i2;
            }
            if (i2 > n15) {
                n15 = i2;
            }
            if (bl4) {
                this.barcode.set(i2, DESELECTED, 1);
                this.addDeselectEvent(n16, i2 - n16, e2);
                continue;
            }
            this.barcode.set(i2, SELECTED, 1);
            int n17 = this.barcode.getColourIndex(i2, SELECTED);
            this.addSelectEvent(n17, i2 - n17, e2);
        }
        this.commitAll();
        if (n6 != -1) {
            n14 = Math.min(n14, n6);
            n15 = Math.max(n15, n6);
        }
        if (n7 != -1) {
            n14 = Math.min(n14, n7);
            n15 = Math.max(n15, n7);
        }
        if (n14 <= n15) {
            this.fireSelectionChanged(n14, n15);
        }
    }

    private boolean isSelectable(int n2) {
        if (this.validSelectionMatchers.isEmpty()) {
            return true;
        }
        Object e2 = this.source.get(n2);
        Iterator<Matcher<E>> iterator = this.validSelectionMatchers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().matches(e2)) continue;
            return false;
        }
        return true;
    }

    public void addSelectionListener(Listener listener) {
        if (listener != null) {
            this.selectionListeners.add(listener);
        }
    }

    public void removeSelectionListener(Listener listener) {
        if (listener != null) {
            this.selectionListeners.remove(listener);
        }
    }

    private void fireSelectionChanged(int n2, int n3) {
        Iterator<Listener> iterator = this.selectionListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().selectionChanged(n2, n3);
        }
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        this.selectionListeners.clear();
        if (this.selectedList != null) {
            this.source.getPublisher().clearRelatedListener(this.selectedList, this);
        }
        if (this.deselectedList != null) {
            this.source.getPublisher().clearRelatedListener(this.deselectedList, this);
        }
        if (this.selectedToggleList != null) {
            this.source.getPublisher().clearRelatedListener(this.selectedToggleList, this);
        }
        if (this.deselectedToggleList != null) {
            this.source.getPublisher().clearRelatedListener(this.deselectedToggleList, this);
        }
    }

    private class DeselectionToggleList<E>
    extends DeselectedList<E> {
        DeselectionToggleList(EventList<E> eventList) {
            super(eventList);
        }

        @Override
        public E set(int n2, E e2) {
            throw new UnsupportedOperationException("Toggling lists don't support setting items");
        }

        @Override
        public void add(int n2, E e2) {
            n2 = this.source.indexOf(e2);
            if (n2 == -1) {
                throw new IllegalArgumentException("Added item " + e2 + " must be in source list");
            }
            ListSelection.this.deselect(n2);
        }

        @Override
        public E remove(int n2) {
            if (n2 < 0 || n2 >= this.size()) {
                throw new IndexOutOfBoundsException("Cannot remove at " + n2 + " on list of size " + this.size());
            }
            int n3 = this.getSourceIndex(n2);
            ListSelection.this.select(n3);
            return this.source.get(n3);
        }
    }

    private class DeselectedList<E>
    extends TransformedList<E, E> {
        DeselectedList(EventList<E> eventList) {
            super(eventList);
        }

        @Override
        public int size() {
            return ListSelection.this.barcode.colourSize(DESELECTED);
        }

        @Override
        protected int getSourceIndex(int n2) {
            return ListSelection.this.barcode.getIndex(n2, DESELECTED);
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
        }

        public ListEventAssembler<E> updates() {
            return this.updates;
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public void dispose() {
        }
    }

    private class SelectionToggleList<E>
    extends SelectedList<E> {
        SelectionToggleList(EventList<E> eventList) {
            super(eventList);
        }

        @Override
        public E set(int n2, E e2) {
            throw new UnsupportedOperationException("Toggling lists don't support setting items");
        }

        @Override
        public void add(int n2, E e2) {
            n2 = this.source.indexOf(e2);
            if (n2 == -1) {
                throw new IllegalArgumentException("Added item " + e2 + " must be in source list");
            }
            ListSelection.this.select(n2);
        }

        @Override
        public E remove(int n2) {
            if (n2 < 0 || n2 >= this.size()) {
                throw new IndexOutOfBoundsException("Cannot remove at " + n2 + " on list of size " + this.size());
            }
            int n3 = this.getSourceIndex(n2);
            ListSelection.this.deselect(n3);
            return this.source.get(n3);
        }
    }

    private class SelectedList<E>
    extends TransformedList<E, E> {
        SelectedList(EventList<E> eventList) {
            super(eventList);
        }

        @Override
        public int size() {
            return ListSelection.this.barcode.colourSize(SELECTED);
        }

        @Override
        protected int getSourceIndex(int n2) {
            return ListSelection.this.barcode.getIndex(n2, SELECTED);
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
        }

        public ListEventAssembler<E> updates() {
            return this.updates;
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public void dispose() {
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void selectionChanged(int var1, int var2);
    }
}

