/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Guard {
    private Guard() {
        throw new UnsupportedOperationException();
    }

    public static <E, L extends EventList<E>> void acceptWithReadLock(L l2, Consumer<L> consumer) {
        if (l2 == null) {
            return;
        }
        l2.getReadWriteLock().readLock().lock();
        try {
            consumer.accept(l2);
        }
        finally {
            l2.getReadWriteLock().readLock().unlock();
        }
    }

    public static <E, L extends EventList<E>> void acceptWithWriteLock(L l2, Consumer<L> consumer) {
        if (l2 == null) {
            return;
        }
        l2.getReadWriteLock().writeLock().lock();
        try {
            consumer.accept(l2);
        }
        finally {
            l2.getReadWriteLock().writeLock().unlock();
        }
    }

    public static <E, L extends EventList<E>, R> R applyWithReadLock(L l2, Function<L, R> function) {
        l2.getReadWriteLock().readLock().lock();
        try {
            R r2 = function.apply(l2);
            return r2;
        }
        finally {
            l2.getReadWriteLock().readLock().unlock();
        }
    }

    public static <E, L extends EventList<E>, R> R applyWithWriteLock(L l2, Function<L, R> function) {
        l2.getReadWriteLock().writeLock().lock();
        try {
            R r2 = function.apply(l2);
            return r2;
        }
        finally {
            l2.getReadWriteLock().writeLock().unlock();
        }
    }
}

