/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class GroupingList<E>
extends TransformedList<E, List<E>> {
    private SimpleTree<GroupList> groupLists = new SimpleTree();
    private final Grouper<E> grouper;

    public static <E extends Comparable<? super E>> GroupingList<E> create(EventList<E> eventList) {
        return new GroupingList<E>(eventList);
    }

    public GroupingList(EventList<E> eventList) {
        this(eventList, GlazedLists.comparableComparator());
    }

    public GroupingList(EventList<E> eventList, Comparator<? super E> comparator) {
        this(new SortedList<E>(eventList, comparator), comparator, null);
    }

    private GroupingList(SortedList<E> sortedList, Comparator<? super E> comparator, Void void_) {
        super(sortedList);
        this.grouper = new Grouper<E>(sortedList, new GrouperClient());
        this.rebuildGroupListTreeFromBarcode();
        sortedList.addListEventListener(this);
    }

    private void rebuildGroupListTreeFromBarcode() {
        this.groupLists.clear();
        GrouperClient grouperClient = (GrouperClient)this.grouper.getClient();
        int n2 = this.grouper.getBarcode().colourSize(Grouper.UNIQUE);
        for (int i2 = 0; i2 < n2; ++i2) {
            grouperClient.insertGroupList(i2);
        }
    }

    public int indexOfGroup(E e2) {
        int n2 = ((SortedList)this.source).sortIndex(e2);
        if (n2 == this.source.size() || this.grouper.getComparator().compare(this.source.get(n2), e2) != 0) {
            return -1;
        }
        return this.grouper.getBarcode().getColourIndex(n2, Grouper.UNIQUE);
    }

    public void setComparator(Comparator<? super E> comparator) {
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        ((SortedList)this.source).setComparator(comparator);
    }

    @Override
    protected int getSourceIndex(int n2) {
        return this.grouper.getBarcode().getIndex(n2, Grouper.UNIQUE);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updates.beginEvent(true);
        SortedList sortedList = (SortedList)this.source;
        Comparator comparator = sortedList.getComparator();
        if (comparator != this.grouper.getComparator()) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.updates.elementDeleted(0, this.get(i2));
            }
            this.grouper.setComparator(comparator);
            this.rebuildGroupListTreeFromBarcode();
            this.updates.addInsert(0, this.size() - 1);
        } else {
            this.grouper.listChanged(listEvent);
        }
        this.updates.commitEvent();
    }

    @Override
    public List<E> get(int n2) {
        return this.groupLists.get(n2).get();
    }

    @Override
    public List<E> remove(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + n2 + " on list of size " + this.size());
        }
        Object object = this.get(n2);
        ArrayList arrayList = new ArrayList(object);
        object.clear();
        return arrayList;
    }

    @Override
    public List<E> set(int n2, List<E> list) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + n2 + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        Object object = this.remove(n2);
        this.add(n2, list);
        this.updates.commitEvent();
        return object;
    }

    @Override
    public void add(int n2, List<E> list) {
        this.source.addAll(list);
    }

    @Override
    public int size() {
        return this.grouper.getBarcode().colourSize(Grouper.UNIQUE);
    }

    @Override
    public void dispose() {
        ((SortedList)this.source).dispose();
        super.dispose();
    }

    private class GroupList
    extends AbstractList<E> {
        private Element<GroupList> treeNode;

        private GroupList() {
        }

        private void setTreeNode(Element<GroupList> element) {
            this.treeNode = element;
        }

        private int getStartIndex() {
            if (this.treeNode == null) {
                return -1;
            }
            int n2 = GroupingList.this.groupLists.indexOfNode(this.treeNode, (byte)1);
            return GroupingList.this.getSourceIndex(n2);
        }

        private int getEndIndex() {
            if (this.treeNode == null) {
                return -1;
            }
            int n2 = GroupingList.this.groupLists.indexOfNode(this.treeNode, (byte)1);
            if (n2 < GroupingList.this.grouper.getBarcode().blackSize() - 1) {
                return GroupingList.this.grouper.getBarcode().getIndex(n2 + 1, Grouper.UNIQUE);
            }
            return GroupingList.this.grouper.getBarcode().size();
        }

        private int getSourceIndex(int n2) {
            return this.getStartIndex() + n2;
        }

        @Override
        public E set(int n2, E e2) {
            return GroupingList.this.source.set(this.getSourceIndex(n2), e2);
        }

        @Override
        public E get(int n2) {
            return GroupingList.this.source.get(this.getSourceIndex(n2));
        }

        @Override
        public int size() {
            return this.getEndIndex() - this.getStartIndex();
        }

        @Override
        public void clear() {
            GroupingList.this.source.subList(this.getStartIndex(), this.getEndIndex()).clear();
        }

        @Override
        public E remove(int n2) {
            return GroupingList.this.source.remove(this.getSourceIndex(n2));
        }

        @Override
        public void add(int n2, E e2) {
            GroupingList.this.source.add(this.getSourceIndex(n2), e2);
        }
    }

    private class GrouperClient
    implements Grouper.Client<E> {
        private GrouperClient() {
        }

        @Override
        public void groupChanged(int n2, int n3, int n4, boolean bl, int n5, E e2, E e3, boolean bl2, boolean bl3) {
            if (n4 == 2) {
                this.insertGroupList(n3);
                GroupingList.this.updates.addInsert(n3);
            } else if (n4 == 0) {
                this.removeGroupList(n3);
                GroupingList.this.updates.addDelete(n3);
            } else if (n4 == 1) {
                GroupingList.this.updates.addUpdate(n3);
            } else {
                throw new IllegalStateException();
            }
        }

        private void insertGroupList(int n2) {
            GroupList groupList = new GroupList();
            Element<GroupList> element = GroupingList.this.groupLists.add(n2, groupList, 1);
            groupList.setTreeNode(element);
        }

        private void removeGroupList(int n2) {
            Element element = GroupingList.this.groupLists.get(n2);
            GroupingList.this.groupLists.remove(element);
            ((GroupList)element.get()).setTreeNode(null);
        }
    }
}

