/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.DisposableMap;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.LockbasedSyncListener;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SyncListener;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.Diff;
import ca.odell.glazedlists.impl.FunctionListMap;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.GroupingListMultiMap;
import ca.odell.glazedlists.impl.ListCollectionListModel;
import ca.odell.glazedlists.impl.ObservableConnector;
import ca.odell.glazedlists.impl.ReadOnlyList;
import ca.odell.glazedlists.impl.SimpleFunctionList;
import ca.odell.glazedlists.impl.ThreadSafeList;
import ca.odell.glazedlists.impl.TypeSafetyListener;
import ca.odell.glazedlists.impl.WeakReferenceProxy;
import ca.odell.glazedlists.impl.beans.BeanConnector;
import ca.odell.glazedlists.impl.beans.BeanFunction;
import ca.odell.glazedlists.impl.beans.BeanTableFormat;
import ca.odell.glazedlists.impl.beans.BeanTextFilterator;
import ca.odell.glazedlists.impl.beans.BeanThresholdEvaluator;
import ca.odell.glazedlists.impl.beans.StringBeanFunction;
import ca.odell.glazedlists.impl.filter.StringTextFilterator;
import ca.odell.glazedlists.impl.functions.ConstantFunction;
import ca.odell.glazedlists.impl.sort.BeanPropertyComparator;
import ca.odell.glazedlists.impl.sort.BooleanComparator;
import ca.odell.glazedlists.impl.sort.ComparableComparator;
import ca.odell.glazedlists.impl.sort.ComparatorChain;
import ca.odell.glazedlists.impl.sort.ReverseComparator;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Set;

public final class GlazedLists {
    private static Comparator<Boolean> booleanComparator = null;
    private static Comparator<Comparable> comparableComparator = null;
    private static Comparator<Comparable> reversedComparable = null;
    private static TextFilterator<Object> stringTextFilterator = null;

    private GlazedLists() {
        throw new UnsupportedOperationException();
    }

    public static <E> void replaceAll(EventList<E> eventList, List<E> list, boolean bl) {
        Diff.replaceAll(eventList, list, bl);
    }

    public static <E> void replaceAll(EventList<E> eventList, List<E> list, boolean bl, Comparator<E> comparator) {
        Diff.replaceAll(eventList, list, bl, comparator);
    }

    public static <E> void replaceAllSorted(EventList<E> eventList, Collection<E> collection, boolean bl, Comparator<E> comparator) {
        GlazedListsImpl.replaceAll(eventList, collection, bl, comparator);
    }

    public static <T> Comparator<T> beanPropertyComparator(Class<T> clazz, String string, String ... stringArray) {
        Comparator<T> comparator = GlazedLists.beanPropertyComparator(clazz, string, GlazedLists.comparableComparator());
        if (stringArray.length == 0) {
            return comparator;
        }
        ArrayList<Comparator<T>> arrayList = new ArrayList<Comparator<T>>(stringArray.length + 1);
        arrayList.add(comparator);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(GlazedLists.beanPropertyComparator(clazz, stringArray[i2], GlazedLists.comparableComparator()));
        }
        return GlazedLists.chainComparators(arrayList);
    }

    public static <T> Comparator<T> beanPropertyComparator(Class<T> clazz, String string, Comparator comparator) {
        return new BeanPropertyComparator<T>(clazz, string, comparator);
    }

    public static Comparator<Boolean> booleanComparator() {
        if (booleanComparator == null) {
            booleanComparator = new BooleanComparator();
        }
        return booleanComparator;
    }

    public static Comparator<String> caseInsensitiveComparator() {
        return String.CASE_INSENSITIVE_ORDER;
    }

    public static <T> Comparator<T> chainComparators(List<Comparator<T>> list) {
        return new ComparatorChain<T>(list);
    }

    @SafeVarargs
    public static <T> Comparator<T> chainComparators(Comparator<T> ... comparatorArray) {
        return GlazedLists.chainComparators(Arrays.asList(comparatorArray));
    }

    public static <T extends Comparable> Comparator<T> comparableComparator() {
        if (comparableComparator == null) {
            comparableComparator = new ComparableComparator();
        }
        return comparableComparator;
    }

    public static <T extends Comparable> Comparator<T> reverseComparator() {
        if (reversedComparable == null) {
            reversedComparable = GlazedLists.reverseComparator(GlazedLists.comparableComparator());
        }
        return reversedComparable;
    }

    public static <T> Comparator<T> reverseComparator(Comparator<T> comparator) {
        return new ReverseComparator<T>(comparator);
    }

    public static <T> TableFormat<T> tableFormat(String[] stringArray, String[] stringArray2) {
        return new BeanTableFormat(null, stringArray, stringArray2);
    }

    public static <T> TableFormat<T> tableFormat(Class<T> clazz, String[] stringArray, String[] stringArray2) {
        return new BeanTableFormat<T>(clazz, stringArray, stringArray2);
    }

    public static <T> TableFormat<T> tableFormat(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        return new BeanTableFormat(null, stringArray, stringArray2, blArray);
    }

    public static <T> TableFormat<T> tableFormat(Class<T> clazz, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        return new BeanTableFormat<T>(clazz, stringArray, stringArray2, blArray);
    }

    public static <E> TextFilterator<E> textFilterator(String ... stringArray) {
        return new BeanTextFilterator(stringArray);
    }

    public static <E> TextFilterator<E> textFilterator(Class<E> clazz, String ... stringArray) {
        return new BeanTextFilterator(clazz, stringArray);
    }

    public static <D, E> Filterator<D, E> filterator(String ... stringArray) {
        return new BeanTextFilterator(stringArray);
    }

    public static <D, E> Filterator<D, E> filterator(Class<E> clazz, String ... stringArray) {
        return new BeanTextFilterator(clazz, stringArray);
    }

    public static <E> TextFilterator<E> toStringTextFilterator() {
        if (stringTextFilterator == null) {
            stringTextFilterator = new StringTextFilterator<Object>();
        }
        return stringTextFilterator;
    }

    public static <E> ThresholdList.Evaluator<E> thresholdEvaluator(String string) {
        return new BeanThresholdEvaluator(string);
    }

    public static <E> CollectionList.Model<List<E>, E> listCollectionListModel() {
        return new ListCollectionListModel();
    }

    @SafeVarargs
    public static <E> EventList<E> eventListOf(E ... EArray) {
        return GlazedLists.eventList(EArray == null ? Collections.emptyList() : Arrays.asList(EArray));
    }

    public static <E> EventList<E> eventList(Collection<? extends E> collection) {
        BasicEventList<E> basicEventList = new BasicEventList<E>(collection == null ? 0 : collection.size());
        if (collection != null) {
            basicEventList.addAll(collection);
        }
        return basicEventList;
    }

    @SafeVarargs
    public static <E> EventList<E> eventListOf(ListEventPublisher listEventPublisher, ReadWriteLock readWriteLock, E ... EArray) {
        return GlazedLists.eventList(listEventPublisher, readWriteLock, EArray == null ? Collections.emptyList() : Arrays.asList(EArray));
    }

    public static <E> EventList<E> eventList(ListEventPublisher listEventPublisher, ReadWriteLock readWriteLock, Collection<? extends E> collection) {
        BasicEventList<E> basicEventList = new BasicEventList<E>(collection == null ? 0 : collection.size(), listEventPublisher, readWriteLock);
        if (collection != null) {
            basicEventList.addAll(collection);
        }
        return basicEventList;
    }

    public static <E> TransformedList<E, E> readOnlyList(EventList<? extends E> eventList) {
        return new ReadOnlyList<E>(eventList);
    }

    public static <E> TransformedList<E, E> threadSafeList(EventList<? extends E> eventList) {
        return new ThreadSafeList<E>(eventList);
    }

    public static <S, E> TransformedList<S, E> transformByFunction(EventList<S> eventList, FunctionList.Function<S, E> function) {
        return new SimpleFunctionList<S, E>(eventList, function);
    }

    public static <E> ListEventListener<E> weakReferenceProxy(EventList<E> eventList, ListEventListener<E> listEventListener) {
        return new WeakReferenceProxy<E>(eventList, listEventListener);
    }

    public static <E> ObservableElementList.Connector<E> beanConnector(Class<E> clazz) {
        return new BeanConnector<E>(clazz);
    }

    public static <E> ObservableElementList.Connector<E> beanConnector(Class<E> clazz, boolean bl, String ... stringArray) {
        Matcher<PropertyChangeEvent> matcher = Matchers.propertyEventNameMatcher(bl, stringArray);
        return GlazedLists.beanConnector(clazz, matcher);
    }

    public static <E> ObservableElementList.Connector<E> beanConnector(Class<E> clazz, Matcher<PropertyChangeEvent> matcher) {
        return new BeanConnector<E>(clazz, matcher);
    }

    public static <E> ObservableElementList.Connector<E> beanConnector(Class<E> clazz, String string, String string2) {
        return new BeanConnector<E>(clazz, string, string2);
    }

    public static <E> ObservableElementList.Connector<E> beanConnector(Class<E> clazz, String string, String string2, Matcher<PropertyChangeEvent> matcher) {
        return new BeanConnector<E>(clazz, string, string2, matcher);
    }

    public static <E extends Observable> ObservableElementList.Connector<E> observableConnector() {
        return new ObservableConnector();
    }

    @Deprecated
    public static <E> Matcher<E> beanPropertyMatcher(Class<E> clazz, String string, Object object) {
        return Matchers.beanPropertyMatcher(clazz, string, object);
    }

    public static <E> MatcherEditor<E> fixedMatcherEditor(Matcher<E> matcher) {
        return MatcherEditor.fromMatcher(matcher);
    }

    public static <E, V> FunctionList.Function<E, V> constantFunction(V v2) {
        return new ConstantFunction(v2);
    }

    public static <E> FunctionList.Function<E, String> toStringFunction(Class<E> clazz, String string) {
        return new StringBeanFunction<E>(clazz, string);
    }

    public static <E, V> FunctionList.Function<E, V> beanFunction(Class<E> clazz, String string) {
        return new BeanFunction(clazz, string);
    }

    public static <E> SyncListener<E> syncEventListToList(EventList<E> eventList, List<E> list) {
        return new SyncListener<E>(eventList, list);
    }

    public static <E> LockbasedSyncListener<E> syncEventListToEventList(EventList<E> eventList, EventList<E> eventList2) {
        eventList2.getReadWriteLock().writeLock().lock();
        try {
            LockbasedSyncListener<E> lockbasedSyncListener = new LockbasedSyncListener<E>(eventList, eventList2);
            return lockbasedSyncListener;
        }
        finally {
            eventList2.getReadWriteLock().writeLock().unlock();
        }
    }

    public static <E> ListEventListener<E> typeSafetyListener(EventList<E> eventList, Set<Class> set) {
        return new TypeSafetyListener<E>(eventList, set);
    }

    public static <K extends Comparable, V> DisposableMap<K, List<V>> syncEventListToMultiMap(EventList<V> eventList, FunctionList.Function<V, ? extends K> function) {
        return GlazedLists.syncEventListToMultiMap(eventList, function, GlazedLists.comparableComparator());
    }

    public static <K, V> DisposableMap<K, List<V>> syncEventListToMultiMap(EventList<V> eventList, FunctionList.Function<V, ? extends K> function, Comparator<? super K> comparator) {
        return new GroupingListMultiMap<K, V>(eventList, function, comparator);
    }

    public static <K, V> DisposableMap<K, V> syncEventListToMap(EventList<V> eventList, FunctionList.Function<V, K> function) {
        return new FunctionListMap<K, V>(eventList, function);
    }
}

