/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Predicate;

public final class FunctionList<S, E>
extends TransformedList<S, E>
implements RandomAccess {
    private final ArrayList<S> sourceElements = new ArrayList();
    private boolean needDispose = false;
    private final List<E> mappedElements;
    private AdvancedFunction<S, E> forward;
    private Function<E, S> reverse;

    public FunctionList(EventList<S> eventList, Function<S, E> function) {
        this(eventList, function, null);
    }

    public FunctionList(EventList<S> eventList, Function<S, E> function, Function<E, S> function2) {
        super(eventList);
        this.updateForwardFunction(function);
        this.setReverseFunction(function2);
        this.mappedElements = new ArrayList(eventList.size());
        eventList.forEach(object -> this.mappedElements.add(this.forward(object)));
        eventList.addListEventListener(this);
    }

    private E forward(S s2) {
        return (E)this.forward.evaluate(s2);
    }

    private E forward(E e2, S s2) {
        return this.forward.reevaluate(s2, e2);
    }

    private S reverse(E e2) {
        if (this.reverse == null) {
            throw new IllegalStateException("A reverse mapping function must be specified to support this List operation");
        }
        return this.reverse.evaluate(e2);
    }

    public void setForwardFunction(Function<S, E> function) {
        this.updateForwardFunction(function);
        this.updates.beginEvent(true);
        int n2 = this.source.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            E e2 = this.forward(this.source.get(i2));
            E e3 = this.mappedElements.set(i2, e2);
            this.updates.elementUpdated(i2, e3, e2);
        }
        this.updates.commitEvent();
    }

    private void updateForwardFunction(Function<S, E> function) {
        if (function == null) {
            throw new IllegalArgumentException("forward Function may not be null");
        }
        if (function instanceof AdvancedFunction) {
            this.forward = (AdvancedFunction)function;
            if (!this.needDispose) {
                this.needDispose = true;
                this.sourceElements.ensureCapacity(this.source.size());
                this.sourceElements.clear();
                this.sourceElements.addAll(this.source);
            }
        } else {
            this.forward = new AdvancedFunctionAdapter<S, E>(function);
            this.needDispose = false;
            this.sourceElements.clear();
            this.sourceElements.trimToSize();
        }
    }

    public Function<S, E> getForwardFunction() {
        if (this.forward instanceof AdvancedFunctionAdapter) {
            return ((AdvancedFunctionAdapter)this.forward).getDelegate();
        }
        return this.forward;
    }

    public void setReverseFunction(Function<E, S> function) {
        this.reverse = function;
    }

    public Function<E, S> getReverseFunction() {
        return this.reverse;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<S> listEvent) {
        this.updates.beginEvent(true);
        if (listEvent.isReordering()) {
            int[] nArray = listEvent.getReorderMap();
            ArrayList<E> arrayList = new ArrayList<E>(this.mappedElements);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                this.mappedElements.set(i2, arrayList.get(n2));
            }
            this.updates.reorder(nArray);
        } else {
            while (listEvent.next()) {
                Object object;
                Object e2;
                int n3 = listEvent.getIndex();
                int n4 = listEvent.getType();
                if (n4 == 2) {
                    e2 = this.source.get(n3);
                    object = this.forward(e2);
                    if (this.needDispose) {
                        this.sourceElements.add(n3, e2);
                    }
                    this.mappedElements.add(n3, object);
                    this.updates.elementInserted(n3, object);
                    continue;
                }
                if (n4 == 1) {
                    e2 = this.get(n3);
                    object = this.source.get(n3);
                    Object e3 = this.forward(e2, object);
                    if (this.needDispose) {
                        this.sourceElements.set(n3, object);
                    }
                    this.mappedElements.set(n3, e3);
                    this.updates.elementUpdated(n3, e2, e3);
                    continue;
                }
                if (n4 != 0) continue;
                e2 = this.mappedElements.remove(n3);
                if (this.needDispose) {
                    object = this.sourceElements.remove(n3);
                    this.forward.dispose(object, e2);
                }
                this.updates.elementDeleted(n3, e2);
            }
        }
        this.updates.commitEvent();
    }

    @Override
    public E get(int n2) {
        return this.mappedElements.get(n2);
    }

    @Override
    public E remove(int n2) {
        E e2 = this.get(n2);
        this.source.remove(n2);
        return e2;
    }

    @Override
    public E set(int n2, E e2) {
        E e3 = this.get(n2);
        this.source.set(n2, this.reverse(e2));
        return e3;
    }

    @Override
    public void add(int n2, E e2) {
        this.source.add(n2, this.reverse(e2));
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        ListEventAssembler listEventAssembler = this.source instanceof AbstractEventList ? ((AbstractEventList)this.source).updates : null;
        boolean bl = false;
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (!predicate.test(this.mappedElements.get(i2))) continue;
            if (listEventAssembler != null && !bl) {
                listEventAssembler.beginEvent(true);
            }
            bl = true;
            this.remove(i2);
        }
        if (listEventAssembler != null && bl) {
            listEventAssembler.commitEvent();
        }
        return bl;
    }

    private static final class AdvancedFunctionAdapter<A, B>
    implements AdvancedFunction<A, B> {
        private final Function<A, B> delegate;

        AdvancedFunctionAdapter(Function<A, B> function) {
            this.delegate = function;
        }

        @Override
        public B evaluate(A a2) {
            return this.delegate.evaluate(a2);
        }

        @Override
        public B reevaluate(A a2, B b2) {
            return this.evaluate(a2);
        }

        @Override
        public void dispose(A a2, B b2) {
        }

        public Function<A, B> getDelegate() {
            return this.delegate;
        }
    }

    public static interface AdvancedFunction<A, B>
    extends Function<A, B> {
        public B reevaluate(A var1, B var2);

        public void dispose(A var1, B var2);
    }

    @FunctionalInterface
    public static interface Function<A, B>
    extends java.util.function.Function<A, B> {
        public B evaluate(A var1);

        @Override
        default public B apply(A a2) {
            return this.evaluate(a2);
        }
    }
}

