/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.List;

public final class FreezableList<E>
extends TransformedList<E, E> {
    private boolean frozen = false;
    private List<E> frozenData = new ArrayList();

    public FreezableList(EventList<E> eventList) {
        super(eventList);
        eventList.addListEventListener(this);
    }

    @Override
    public E get(int n2) {
        if (this.frozen) {
            return this.frozenData.get(n2);
        }
        return this.source.get(n2);
    }

    @Override
    public int size() {
        if (this.frozen) {
            return this.frozenData.size();
        }
        return this.source.size();
    }

    @Override
    protected boolean isWritable() {
        return !this.frozen;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot freeze a list that is already frozen");
        }
        this.source.removeListEventListener(this);
        this.frozenData.addAll(this.source);
        this.frozen = true;
    }

    public void thaw() {
        int n2;
        if (!this.frozen) {
            throw new IllegalStateException("Cannot thaw a list that is not frozen");
        }
        this.updates.beginEvent();
        int n3 = this.frozenData.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.updates.elementDeleted(0, this.frozenData.get(n2));
        }
        n3 = this.source.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.updates.elementInserted(0, this.source.get(n2));
        }
        this.frozenData.clear();
        this.frozen = false;
        this.source.addListEventListener(this);
        this.updates.commitEvent();
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        if (!this.frozen) {
            this.updates.forwardEvent(listEvent);
        }
    }
}

