/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;

public final class FilterList<E>
extends TransformedList<E, E> {
    private Barcode flagList = new Barcode();
    private Matcher<? super E> currentMatcher = Matchers.trueMatcher();
    private MatcherEditor<? super E> currentEditor = null;
    private final MatcherEditor.Listener listener = new PrivateMatcherEditorListener();
    private volatile boolean disposed;

    public FilterList(EventList<E> eventList) {
        super(eventList);
        this.flagList.addBlack(0, eventList.size());
        eventList.addListEventListener(this);
    }

    public FilterList(EventList<E> eventList, Matcher<? super E> matcher) {
        this(eventList);
        if (matcher == null) {
            return;
        }
        this.currentMatcher = matcher;
    }

    public FilterList(EventList<E> eventList, MatcherEditor<? super E> matcherEditor) {
        this(eventList);
        if (matcherEditor == null) {
            return;
        }
        this.currentEditor = matcherEditor;
        this.currentEditor.addMatcherEditorListener(this.listener);
        this.currentMatcher = this.currentEditor.getMatcher();
    }

    public void setMatcher(Matcher<? super E> matcher) {
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
            this.currentEditor = null;
        }
        if (matcher != null) {
            this.changeMatcherWithLocks(this.currentEditor, matcher, 4);
        } else {
            this.changeMatcherWithLocks(this.currentEditor, null, 0);
        }
    }

    public void setMatcherEditor(MatcherEditor<? super E> matcherEditor) {
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
        }
        this.currentEditor = matcherEditor;
        if (this.currentEditor != null) {
            this.currentEditor.addMatcherEditorListener(this.listener);
            this.changeMatcherWithLocks(this.currentEditor, this.currentEditor.getMatcher(), 4);
        } else {
            this.changeMatcherWithLocks(this.currentEditor, null, 0);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
        }
        this.disposed = true;
        this.currentEditor = null;
        this.currentMatcher = null;
    }

    @Override
    public final void listChanged(ListEvent<E> listEvent) {
        this.updates.beginEvent();
        if (listEvent.isReordering()) {
            int[] nArray = listEvent.getReorderMap();
            int[] nArray2 = new int[this.flagList.blackSize()];
            Barcode barcode = this.flagList;
            this.flagList = new Barcode();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Object object = barcode.get(nArray[i2]);
                this.flagList.add(i2, object, 1);
                if (object == Barcode.WHITE) continue;
                nArray2[this.flagList.getBlackIndex((int)i2)] = barcode.getBlackIndex(nArray[i2]);
            }
            this.updates.reorder(nArray2);
        } else {
            while (listEvent.next()) {
                int n2 = listEvent.getIndex();
                int n3 = listEvent.getType();
                if (n3 == 0) {
                    int n4 = this.flagList.getBlackIndex(n2);
                    if (n4 != -1) {
                        E e2 = listEvent.getOldValue();
                        this.updates.elementDeleted(n4, e2);
                    }
                    this.flagList.remove(n2, 1);
                    continue;
                }
                if (n3 == 2) {
                    Object e3 = this.source.get(n2);
                    boolean bl = this.currentMatcher.matches(e3);
                    if (bl) {
                        this.flagList.addBlack(n2, 1);
                        int n5 = this.flagList.getBlackIndex(n2);
                        this.updates.elementInserted(n5, e3);
                        continue;
                    }
                    this.flagList.addWhite(n2, 1);
                    continue;
                }
                if (n3 != 1) continue;
                int n6 = this.flagList.getBlackIndex(n2);
                boolean bl = n6 != -1;
                Object e4 = this.source.get(n2);
                boolean bl2 = this.currentMatcher.matches(e4);
                if (bl && !bl2) {
                    this.flagList.setWhite(n2, 1);
                    this.updates.elementDeleted(n6, listEvent.getOldValue());
                    continue;
                }
                if (!bl && bl2) {
                    this.flagList.setBlack(n2, 1);
                    this.updates.elementInserted(this.flagList.getBlackIndex(n2), e4);
                    continue;
                }
                if (!bl || !bl2) continue;
                this.updates.elementUpdated(n6, listEvent.getOldValue(), e4);
            }
        }
        this.updates.commitEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeMatcherWithLocks(MatcherEditor<? super E> matcherEditor, Matcher<? super E> matcher, int n2) {
        this.getReadWriteLock().writeLock().lock();
        try {
            this.changeMatcher(matcherEditor, matcher, n2);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    private void changeMatcher(MatcherEditor<? super E> matcherEditor, Matcher<? super E> matcher, int n2) {
        if (!this.disposed) {
            if (this.currentEditor != matcherEditor) {
                throw new IllegalStateException();
            }
            switch (n2) {
                case 2: {
                    this.currentMatcher = matcher;
                    this.constrained();
                    break;
                }
                case 3: {
                    this.currentMatcher = matcher;
                    this.relaxed();
                    break;
                }
                case 4: {
                    this.currentMatcher = matcher;
                    this.changed();
                    break;
                }
                case 0: {
                    this.currentMatcher = Matchers.trueMatcher();
                    this.matchAll();
                    break;
                }
                case 1: {
                    this.currentMatcher = Matchers.falseMatcher();
                    this.matchNone();
                }
            }
        }
    }

    private void matchNone() {
        this.updates.beginEvent();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.updates.elementDeleted(0, this.get(i2));
        }
        this.flagList.clear();
        this.flagList.addWhite(0, this.source.size());
        this.updates.commitEvent();
    }

    private void matchAll() {
        this.updates.beginEvent();
        BarcodeIterator barcodeIterator = this.flagList.iterator();
        while (barcodeIterator.hasNextWhite()) {
            barcodeIterator.nextWhite();
            int n2 = barcodeIterator.getIndex();
            this.updates.elementInserted(n2, this.source.get(n2));
        }
        this.flagList.clear();
        this.flagList.addBlack(0, this.source.size());
        this.updates.commitEvent();
    }

    private void relaxed() {
        this.updates.beginEvent();
        BarcodeIterator barcodeIterator = this.flagList.iterator();
        while (barcodeIterator.hasNextWhite()) {
            barcodeIterator.nextWhite();
            Object e2 = this.source.get(barcodeIterator.getIndex());
            if (!this.currentMatcher.matches(e2)) continue;
            this.updates.elementInserted(barcodeIterator.setBlack(), e2);
        }
        this.updates.commitEvent();
    }

    private void constrained() {
        this.updates.beginEvent();
        BarcodeIterator barcodeIterator = this.flagList.iterator();
        while (barcodeIterator.hasNextBlack()) {
            barcodeIterator.nextBlack();
            Object e2 = this.source.get(barcodeIterator.getIndex());
            if (this.currentMatcher.matches(e2)) continue;
            int n2 = barcodeIterator.getBlackIndex();
            barcodeIterator.setWhite();
            this.updates.elementDeleted(n2, e2);
        }
        this.updates.commitEvent();
    }

    private void changed() {
        this.updates.beginEvent();
        BarcodeIterator barcodeIterator = this.flagList.iterator();
        while (barcodeIterator.hasNext()) {
            barcodeIterator.next();
            int n2 = barcodeIterator.getBlackIndex();
            boolean bl = n2 != -1;
            Object e2 = this.source.get(barcodeIterator.getIndex());
            boolean bl2 = this.currentMatcher.matches(e2);
            if (bl && !bl2) {
                barcodeIterator.setWhite();
                this.updates.elementDeleted(n2, e2);
                continue;
            }
            if (bl || !bl2) continue;
            this.updates.elementInserted(barcodeIterator.setBlack(), e2);
        }
        this.updates.commitEvent();
    }

    @Override
    public final int size() {
        return this.flagList.blackSize();
    }

    @Override
    protected final int getSourceIndex(int n2) {
        return this.flagList.getIndex(n2, Barcode.BLACK);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    private class PrivateMatcherEditorListener
    implements MatcherEditor.Listener<E> {
        private PrivateMatcherEditorListener() {
        }

        @Override
        public void changedMatcher(MatcherEditor.Event<E> event) {
            MatcherEditor matcherEditor = event.getMatcherEditor();
            Matcher matcher = event.getMatcher();
            int n2 = event.getType();
            FilterList.this.changeMatcherWithLocks(matcherEditor, matcher, n2);
        }
    }
}

