/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class DebugList<E>
extends AbstractEventList<E> {
    private boolean lockCheckingEnabled;
    private final Set<Thread> sanctionedReaderThreads = new HashSet<Thread>();
    private final Set<Thread> sanctionedWriterThreads = new HashSet<Thread>();
    private EventList<E> delegate;
    private final ListEventListener<E> delegateWatcher = new ListEventForwarder();
    private final DebugReadWriteLock debugReadWriteLock;

    public DebugList() {
        this(null, new DebugReadWriteLock());
    }

    private DebugList(ListEventPublisher listEventPublisher, DebugReadWriteLock debugReadWriteLock) {
        this.debugReadWriteLock = debugReadWriteLock;
        this.delegate = new BasicEventList(listEventPublisher, this.debugReadWriteLock);
        this.delegate.addListEventListener(this.delegateWatcher);
    }

    public boolean isLockCheckingEnabled() {
        return this.lockCheckingEnabled;
    }

    public void setLockCheckingEnabled(boolean bl) {
        this.lockCheckingEnabled = bl;
    }

    public Set<Thread> getSanctionedReaderThreads() {
        return this.sanctionedReaderThreads;
    }

    public Set<Thread> getSanctionedWriterThreads() {
        return this.sanctionedWriterThreads;
    }

    public <E> DebugList<E> createNewDebugList() {
        return new DebugList<E>(this.getPublisher(), this.debugReadWriteLock);
    }

    protected void beforeReadOperation() {
        if (!this.sanctionedReaderThreads.isEmpty() && !this.sanctionedReaderThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a read operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingReadOrWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the readLock prior to a read operation");
        }
    }

    protected void afterReadOperation() {
    }

    protected void beforeWriteOperation() {
        if (!this.sanctionedWriterThreads.isEmpty() && !this.sanctionedWriterThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a write operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the writeLock prior to a write operation");
        }
    }

    protected void afterWriteOperation() {
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    @Override
    public ListEventPublisher getPublisher() {
        return this.delegate.getPublisher();
    }

    @Override
    public E get(int n2) {
        this.beforeReadOperation();
        try {
            Object e2 = this.delegate.get(n2);
            return e2;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int size() {
        this.beforeReadOperation();
        try {
            int n2 = this.delegate.size();
            return n2;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean contains(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.contains(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.containsAll(collection);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean equals(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.equals(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int hashCode() {
        this.beforeReadOperation();
        try {
            int n2 = this.delegate.hashCode();
            return n2;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int indexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n2 = this.delegate.indexOf(object);
            return n2;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int lastIndexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n2 = this.delegate.lastIndexOf(object);
            return n2;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean isEmpty() {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.beforeReadOperation();
        try {
            this.delegate.forEach(consumer);
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public Object[] toArray() {
        this.beforeReadOperation();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.beforeReadOperation();
        try {
            T[] TArray2 = this.delegate.toArray(TArray);
            return TArray2;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public String toString() {
        this.beforeReadOperation();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean add(E e2) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.add(e2);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean remove(Object object) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.remove(object);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.removeIf(predicate);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(collection);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(n2, collection);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.removeAll(collection);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.retainAll(collection);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        this.beforeWriteOperation();
        try {
            this.delegate.replaceAll(unaryOperator);
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        this.beforeWriteOperation();
        try {
            this.delegate.sort(comparator);
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void clear() {
        this.beforeWriteOperation();
        try {
            this.delegate.clear();
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n2, E e2) {
        this.beforeWriteOperation();
        try {
            E e3 = this.delegate.set(n2, e2);
            return e3;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void add(int n2, E e2) {
        this.beforeWriteOperation();
        try {
            this.delegate.add(n2, e2);
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public E remove(int n2) {
        this.beforeWriteOperation();
        try {
            Object e2 = this.delegate.remove(n2);
            return e2;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void dispose() {
        this.delegate.removeListEventListener(this.delegateWatcher);
        this.delegate = null;
    }

    private static class DebugReadWriteLock
    implements ReadWriteLock {
        private final DebugLock readLock;
        private final DebugLock writeLock;

        public DebugReadWriteLock() {
            ReadWriteLock readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
            this.readLock = new DebugLock(readWriteLock.readLock(), null);
            this.writeLock = new DebugLock(readWriteLock.writeLock(), this.readLock);
        }

        @Override
        public Lock readLock() {
            return this.readLock;
        }

        @Override
        public Lock writeLock() {
            return this.writeLock;
        }

        public boolean isThreadHoldingWriteLock() {
            return this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        public boolean isThreadHoldingReadLock() {
            return this.readLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        public boolean isThreadHoldingReadOrWriteLock() {
            return this.readLock.getThreadsHoldingLock().contains(Thread.currentThread()) || this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        private static class DebugLock
        implements Lock {
            private final Lock delegate;
            private final DebugLock readLock;
            private final List<Thread> threadsHoldingLock = Collections.synchronizedList(new ArrayList());

            public DebugLock(Lock lock, DebugLock debugLock) {
                this.delegate = lock;
                this.readLock = debugLock;
            }

            @Override
            public void lock() {
                if (this.readLock != null && this.readLock.getThreadsHoldingLock().contains(Thread.currentThread())) {
                    throw new IllegalStateException("DebugList detected an attempt to acquire a writeLock from a thread already owning a readLock (deadlock)");
                }
                this.delegate.lock();
                this.threadsHoldingLock.add(Thread.currentThread());
            }

            @Override
            public boolean tryLock() {
                if (this.readLock != null && this.readLock.getThreadsHoldingLock().contains(Thread.currentThread())) {
                    throw new IllegalStateException("DebugList detected an attempt to acquire a writeLock from a thread already owning a readLock (deadlock)");
                }
                boolean bl = this.delegate.tryLock();
                if (bl) {
                    this.threadsHoldingLock.add(Thread.currentThread());
                }
                return bl;
            }

            @Override
            public void unlock() {
                this.delegate.unlock();
                this.threadsHoldingLock.remove(Thread.currentThread());
            }

            public List<Thread> getThreadsHoldingLock() {
                return this.threadsHoldingLock;
            }
        }
    }

    private class ListEventForwarder
    implements ListEventListener<E> {
        private ListEventForwarder() {
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            DebugList.this.updates.forwardEvent(listEvent);
        }
    }
}

