/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Iterator;

public class CompositeList<E>
extends CollectionList<EventList<E>, E> {
    public CompositeList() {
        super(new BasicEventList(), GlazedLists.listCollectionListModel());
    }

    @Deprecated
    public CompositeList(ReadWriteLock readWriteLock) {
        super(new BasicEventList(readWriteLock), GlazedLists.listCollectionListModel());
    }

    public CompositeList(ListEventPublisher listEventPublisher, ReadWriteLock readWriteLock) {
        super(new BasicEventList(listEventPublisher, readWriteLock), GlazedLists.listCollectionListModel());
    }

    public void addMemberList(EventList<E> eventList) {
        if (!this.getPublisher().equals(eventList.getPublisher())) {
            throw new IllegalArgumentException("Member list must share publisher with CompositeList");
        }
        if (!this.getReadWriteLock().equals(eventList.getReadWriteLock())) {
            throw new IllegalArgumentException("Member list must share lock with CompositeList");
        }
        this.source.add(eventList);
    }

    public <E> EventList<E> createMemberList() {
        return new BasicEventList(this.getPublisher(), this.getReadWriteLock());
    }

    public void removeMemberList(EventList<E> eventList) {
        Iterator iterator = this.source.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != eventList) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException("Cannot remove list " + eventList + " which is not in this CompositeList");
    }
}

