/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTreeIterator;
import java.util.Collections;
import java.util.List;

public class CollectionList<S, E>
extends TransformedList<S, E>
implements ListEventListener<S> {
    private final ChildElement<E> EMPTY_CHILD_ELEMENT = new SimpleChildElement(Collections.emptyList(), null);
    private final Model<S, E> model;
    private final Barcode barcode = new Barcode();
    private final SimpleTree<ChildElement<E>> childElements = new SimpleTree();

    public CollectionList(EventList<S> eventList, Model<S, E> model) {
        super(eventList);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        int n2 = eventList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            List<S> list = model.getChildren(eventList.get(i2));
            Element<ChildElement<E>> element = this.childElements.add(i2, this.EMPTY_CHILD_ELEMENT, 1);
            element.set(this.createChildElementForList(list, element));
            this.barcode.addBlack(this.barcode.size(), 1);
            if (list.isEmpty()) continue;
            this.barcode.addWhite(this.barcode.size(), list.size());
        }
        eventList.addListEventListener(this);
    }

    @Override
    protected boolean isWritable() {
        return false;
    }

    @Override
    public int size() {
        return this.barcode.whiteSize();
    }

    @Override
    public E get(int n2) {
        ChildElement<E> childElement = this.getChildElement(n2);
        int n3 = this.barcode.getWhiteSequenceIndex(n2);
        return childElement.get(n3);
    }

    @Override
    public E set(int n2, E e2) {
        ChildElement<E> childElement = this.getChildElement(n2);
        int n3 = this.barcode.getWhiteSequenceIndex(n2);
        return childElement.set(n3, e2);
    }

    @Override
    public E remove(int n2) {
        ChildElement<E> childElement = this.getChildElement(n2);
        int n3 = this.barcode.getWhiteSequenceIndex(n2);
        return childElement.remove(n3);
    }

    public int childStartingIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + n2);
        }
        if (n2 >= this.source.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + n2);
        }
        int n3 = this.barcode.getIndex(n2, Barcode.BLACK);
        int n4 = n3 + 1;
        if (n4 >= this.barcode.size()) {
            return -1;
        }
        if (this.barcode.get(n4) != Barcode.WHITE) {
            return -1;
        }
        int n5 = n4 - (n2 + 1);
        assert (this.barcode.getWhiteIndex(n4) == n5);
        return n5;
    }

    public int childEndingIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + n2);
        }
        if (n2 >= this.source.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + n2);
        }
        int n3 = n2 == this.barcode.blackSize() - 1 ? this.barcode.size() : this.barcode.getIndex(n2 + 1, Barcode.BLACK);
        int n4 = n3 - 1;
        if (this.barcode.get(n4) == Barcode.BLACK) {
            return -1;
        }
        int n5 = n4 - (n2 + 1);
        assert (this.barcode.getWhiteIndex(n4) == n5);
        return n5;
    }

    @Override
    public void listChanged(ListEvent<S> listEvent) {
        this.updates.beginEvent();
        while (listEvent.next()) {
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 2) {
                this.handleInsert(n2);
                continue;
            }
            if (n3 == 0) {
                this.handleDelete(n2);
                continue;
            }
            if (n3 != 1) continue;
            this.handleDelete(n2);
            this.handleInsert(n2);
        }
        this.updates.commitEvent();
    }

    @Override
    public void dispose() {
        super.dispose();
        SimpleTreeIterator<ChildElement<E>> simpleTreeIterator = new SimpleTreeIterator<ChildElement<E>>(this.childElements);
        while (simpleTreeIterator.hasNext()) {
            simpleTreeIterator.next();
            simpleTreeIterator.value().dispose();
        }
    }

    private void handleInsert(int n2) {
        int n3 = this.getAbsoluteIndex(n2);
        Object e2 = this.source.get(n2);
        List<E> list = this.model.getChildren(e2);
        Element<ChildElement<E>> element = this.childElements.add(n2, this.EMPTY_CHILD_ELEMENT, 1);
        element.set(this.createChildElementForList(list, element));
        this.barcode.addBlack(n3, 1);
        if (!list.isEmpty()) {
            this.barcode.addWhite(n3 + 1, list.size());
        }
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            E e3 = list.get(i2);
            this.updates.elementInserted(n4, e3);
        }
    }

    private void handleDelete(int n2) {
        int n3 = this.getAbsoluteIndex(n2);
        int n4 = this.getAbsoluteIndex(n2 + 1);
        int n5 = n4 - n3 - 1;
        if (n5 > 0) {
            int n6 = n3 - n2;
            int n7 = n6 + n5;
            for (int i2 = n6; i2 < n7; ++i2) {
                this.updates.elementDeleted(n6, this.get(i2));
            }
        }
        Element<ChildElement<E>> element = this.childElements.get(n2);
        this.childElements.remove(element);
        element.get().dispose();
        this.barcode.remove(n3, 1 + n5);
    }

    private ChildElement<E> getChildElement(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + n2);
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size());
        }
        int n3 = this.barcode.getBlackBeforeWhite(n2);
        return this.childElements.get(n3).get();
    }

    private ChildElement<E> createChildElementForList(List<E> list, Element<ChildElement<E>> element) {
        if (list instanceof EventList) {
            return new EventChildElement((EventList)list, element);
        }
        return new SimpleChildElement(list, element);
    }

    private int getAbsoluteIndex(int n2) {
        if (n2 < this.barcode.blackSize()) {
            return this.barcode.getIndex(n2, Barcode.BLACK);
        }
        if (n2 == this.barcode.blackSize()) {
            return this.barcode.size();
        }
        throw new IndexOutOfBoundsException();
    }

    private class EventChildElement
    implements ChildElement<E>,
    ListEventListener<E> {
        private final EventList<E> children;
        private final Element<ChildElement<E>> node;

        public EventChildElement(EventList<E> eventList, Element<ChildElement<E>> element) {
            this.children = eventList;
            this.node = element;
            if (!CollectionList.this.getPublisher().equals(eventList.getPublisher())) {
                throw new IllegalArgumentException("If a CollectionList.Model returns EventLists, those EventLists must use the same ListEventPublisher as the CollectionList");
            }
            if (!CollectionList.this.getReadWriteLock().equals(eventList.getReadWriteLock())) {
                throw new IllegalArgumentException("If a CollectionList.Model returns EventLists, those EventLists must use the same ReadWriteLock as the CollectionList");
            }
            eventList.getPublisher().setRelatedSubject(this, CollectionList.this);
            eventList.addListEventListener(this);
        }

        @Override
        public E get(int n2) {
            return this.children.get(n2);
        }

        @Override
        public E remove(int n2) {
            return this.children.remove(n2);
        }

        @Override
        public E set(int n2, E e2) {
            return this.children.set(n2, e2);
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            int n2;
            int n3 = CollectionList.this.childElements.indexOfNode(this.node, (byte)1);
            int n4 = CollectionList.this.getAbsoluteIndex(n3);
            int n5 = CollectionList.this.getAbsoluteIndex(n3 + 1);
            int n6 = n5 - (n2 = n4 + 1);
            if (n6 > 0) {
                CollectionList.this.barcode.remove(n2, n6);
            }
            if (!this.children.isEmpty()) {
                CollectionList.this.barcode.addWhite(n2, this.children.size());
            }
            int n7 = n4 - n3;
            CollectionList.this.updates.beginEvent();
            while (listEvent.next()) {
                int n8 = listEvent.getIndex();
                int n9 = listEvent.getType();
                int n10 = n8 + n7;
                switch (n9) {
                    case 2: {
                        CollectionList.this.updates.elementInserted(n10, listEvent.getNewValue());
                        break;
                    }
                    case 1: {
                        CollectionList.this.updates.elementUpdated(n10, listEvent.getOldValue(), listEvent.getNewValue());
                        break;
                    }
                    case 0: {
                        CollectionList.this.updates.elementDeleted(n10, listEvent.getOldValue());
                    }
                }
            }
            CollectionList.this.updates.commitEvent();
        }

        @Override
        public void dispose() {
            this.children.removeListEventListener(this);
            this.children.getPublisher().clearRelatedSubject(this);
        }

        public String toString() {
            return "[" + CollectionList.this.childElements.indexOfNode(this.node, (byte)0) + ":" + this.children + "]";
        }
    }

    private class SimpleChildElement
    implements ChildElement<E> {
        private final List<E> children;
        private final Element<ChildElement<E>> node;

        public SimpleChildElement(List<E> list, Element<ChildElement<E>> element) {
            this.children = list;
            this.node = element;
        }

        @Override
        public E get(int n2) {
            return this.children.get(n2);
        }

        @Override
        public E remove(int n2) {
            Object e2 = this.children.remove(n2);
            int n3 = CollectionList.this.childElements.indexOfNode(this.node, (byte)0);
            int n4 = CollectionList.this.getAbsoluteIndex(n3);
            int n5 = n4 + 1;
            CollectionList.this.barcode.remove(n5 + n2, 1);
            int n6 = n4 - n3;
            CollectionList.this.updates.beginEvent();
            CollectionList.this.updates.elementDeleted(n2 + n6, e2);
            CollectionList.this.updates.commitEvent();
            return e2;
        }

        @Override
        public E set(int n2, E e2) {
            Object e3 = this.children.set(n2, e2);
            int n3 = CollectionList.this.childElements.indexOfNode(this.node, (byte)0);
            int n4 = CollectionList.this.getAbsoluteIndex(n3);
            int n5 = n4 - n3;
            CollectionList.this.updates.beginEvent();
            CollectionList.this.updates.elementUpdated(n2 + n5, e3);
            CollectionList.this.updates.commitEvent();
            return e3;
        }

        @Override
        public void dispose() {
        }
    }

    @FunctionalInterface
    public static interface Model<E, S> {
        public List<S> getChildren(E var1);
    }

    private static interface ChildElement<E> {
        public E get(int var1);

        public E remove(int var1);

        public E set(int var1, E var2);

        public void dispose();
    }
}

