/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class BasicEventList<E>
extends AbstractEventList<E>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 4883958173323072345L;
    private List<E> data;

    public BasicEventList() {
        this(LockFactory.DEFAULT.createReadWriteLock());
    }

    public BasicEventList(ReadWriteLock readWriteLock) {
        this(null, readWriteLock);
    }

    public BasicEventList(int n2) {
        this(n2, null, LockFactory.DEFAULT.createReadWriteLock());
    }

    public BasicEventList(ListEventPublisher listEventPublisher, ReadWriteLock readWriteLock) {
        this(10, listEventPublisher, readWriteLock);
    }

    public BasicEventList(int n2, ListEventPublisher listEventPublisher, ReadWriteLock readWriteLock) {
        super(listEventPublisher);
        this.data = new ArrayList(n2);
        this.readWriteLock = readWriteLock == null ? LockFactory.DEFAULT.createReadWriteLock() : readWriteLock;
    }

    @Deprecated
    public BasicEventList(List<E> list) {
        super(null);
        this.data = list;
        this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
    }

    @Override
    public void add(int n2, E e2) {
        this.updates.beginEvent();
        this.updates.elementInserted(n2, e2);
        this.data.add(n2, e2);
        this.updates.commitEvent();
    }

    @Override
    public boolean add(E e2) {
        this.updates.beginEvent();
        this.updates.elementInserted(this.size(), e2);
        boolean bl = this.data.add(e2);
        this.updates.commitEvent();
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        this.updates.beginEvent();
        for (E e2 : collection) {
            this.updates.elementInserted(n2, e2);
            this.data.add(n2, e2);
            ++n2;
        }
        this.updates.commitEvent();
        return !collection.isEmpty();
    }

    @Override
    public E remove(int n2) {
        this.updates.beginEvent();
        E e2 = this.data.remove(n2);
        this.updates.elementDeleted(n2, e2);
        this.updates.commitEvent();
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.data.indexOf(object);
        if (n2 == -1) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.updates.beginEvent();
        this.data.forEach((? super T object) -> this.updates.elementDeleted(0, object));
        this.data.clear();
        this.updates.commitEvent();
    }

    @Override
    public E set(int n2, E e2) {
        this.updates.beginEvent();
        E e3 = this.data.set(n2, e2);
        this.updates.elementUpdated(n2, e3, e2);
        this.updates.commitEvent();
        return e3;
    }

    @Override
    public E get(int n2) {
        return this.data.get(n2);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        if (this.isEmpty()) {
            return false;
        }
        boolean bl = false;
        this.updates.beginEvent();
        for (int i2 = this.data.size() - 1; i2 >= 0; --i2) {
            if (!predicate.test(this.data.get(i2))) continue;
            E e2 = this.data.remove(i2);
            this.updates.elementDeleted(i2, e2);
            bl = true;
        }
        this.updates.commitEvent();
        return bl;
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        this.updates.beginEvent();
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Object r2;
            E e2 = this.data.get(i2);
            if (e2 == (r2 = unaryOperator.apply(e2))) continue;
            this.data.set(i2, r2);
            this.updates.elementUpdated(i2, e2, r2);
        }
        this.updates.commitEvent();
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.data.forEach(consumer);
    }

    @Override
    public Stream<E> stream() {
        return this.data.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.data.parallelStream();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.data.spliterator();
    }

    @Override
    public void dispose() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = this.data.toArray(new Object[this.data.size()]);
        ArrayList arrayList = new ArrayList(1);
        for (ListEventListener listEventListener : this.updates.getListEventListeners()) {
            if (!(listEventListener instanceof Serializable)) continue;
            arrayList.add(listEventListener);
        }
        ListEventListener[] listEventListenerArray = arrayList.toArray(new ListEventListener[arrayList.size()]);
        objectOutputStream.writeObject(objectArray);
        objectOutputStream.writeObject(listEventListenerArray);
        objectOutputStream.writeObject(this.getPublisher());
        objectOutputStream.writeObject(this.getReadWriteLock());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray = (Object[])objectInputStream.readObject();
        ListEventListener[] listEventListenerArray = (ListEventListener[])objectInputStream.readObject();
        try {
            this.publisher = (ListEventPublisher)objectInputStream.readObject();
            this.updates = new ListEventAssembler(this, this.publisher);
            this.readWriteLock = (ReadWriteLock)objectInputStream.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            if (optionalDataException.eof) {
                this.readWriteLock = LockFactory.DEFAULT.createReadWriteLock();
            }
            throw optionalDataException;
        }
        this.data = new ArrayList(objectArray.length);
        this.data.addAll(Arrays.asList(objectArray));
        for (ListEventListener listEventListener : listEventListenerArray) {
            this.updates.addListEventListener(listEventListener);
        }
    }
}

