/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.impl.EventListIterator;
import ca.odell.glazedlists.impl.SimpleIterator;
import ca.odell.glazedlists.impl.SubEventList;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class AbstractEventList<E>
implements EventList<E> {
    protected ListEventAssembler<E> updates = null;
    protected ReadWriteLock readWriteLock = null;
    protected ListEventPublisher publisher = null;

    protected AbstractEventList(ListEventPublisher listEventPublisher) {
        if (listEventPublisher == null) {
            listEventPublisher = ListEventAssembler.createListEventPublisher();
        }
        this.publisher = listEventPublisher;
        this.updates = new ListEventAssembler(this, listEventPublisher);
    }

    protected AbstractEventList() {
        this(null);
    }

    @Override
    public ListEventPublisher getPublisher() {
        return this.publisher;
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    @Override
    public void addListEventListener(ListEventListener<? super E> listEventListener) {
        this.updates.addListEventListener(listEventListener);
    }

    @Override
    public void removeListEventListener(ListEventListener<? super E> listEventListener) {
        this.updates.removeListEventListener(listEventListener);
    }

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        for (E e2 : this) {
            if (!Objects.equals(object, e2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new SimpleIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n2 = 0;
        for (E e2 : this) {
            objectArray[n2] = e2;
            ++n2;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        } else if (objectArray.length > this.size()) {
            objectArray[this.size()] = null;
        }
        int n2 = 0;
        for (E e2 : this) {
            objectArray[n2] = e2;
            ++n2;
        }
        return objectArray;
    }

    @Override
    public boolean add(E e2) {
        int n2 = this.size();
        this.add(this.size(), e2);
        return this.size() != n2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        if (n2 == -1) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Cannot add at " + n2 + " on list of size " + this.size());
        }
        if (collection.size() == 0) {
            return false;
        }
        int n3 = this.size();
        this.updates.beginEvent(true);
        for (E e2 : collection) {
            try {
                this.add(n2, e2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.updates.discardEvent();
                throw unsupportedOperationException;
            }
            if (n2 >= this.size()) continue;
            ++n2;
        }
        this.updates.commitEvent();
        return this.size() != n3;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.isEmpty()) {
            return false;
        }
        return this.removeIf(collection::contains);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.removeIf(object -> !collection.contains(object));
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.removeIf(object -> true);
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        if (this.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(predicate);
        this.updates.beginEvent(true);
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        this.updates.commitEvent();
        return bl;
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        this.updates.beginEvent(true);
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            Object r2;
            E e2 = this.get(i2);
            if (e2 == (r2 = unaryOperator.apply(e2))) continue;
            try {
                this.set(i2, r2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.updates.discardEvent();
                throw unsupportedOperationException;
            }
            this.updates.elementUpdated(i2, e2, r2);
        }
        this.updates.commitEvent();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size()) {
            return false;
        }
        Iterator<E> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (E e2 : this) {
            n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    @Override
    public abstract E get(int var1);

    @Override
    public E set(int n2, E e2) {
        throw new UnsupportedOperationException("this list does not support set()");
    }

    @Override
    public void add(int n2, E e2) {
        throw new UnsupportedOperationException("this list does not support add()");
    }

    @Override
    public E remove(int n2) {
        throw new UnsupportedOperationException("this list does not support remove()");
    }

    @Override
    public int indexOf(Object object) {
        int n2 = 0;
        for (E e2 : this) {
            if (Objects.equals(object, e2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (!Objects.equals(object, this.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return new EventListIterator(this, n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return new SubEventList(this, n2, n3, true);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(String.valueOf(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

