/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.launcher.Variables;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.MacLauncher;
import com.install4j.runtime.launcher.UnixLauncher;
import com.install4j.runtime.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;

public class LauncherVariables {
    private static String applicationId;
    private static String applicationVersion;
    private static String applicationName;
    private static ResourceBundle messages;
    private static final String MISSING_REPLACEMENT = "null";

    public static String replaceVariables(String value) {
        return LauncherVariables.replaceVariables(value, null);
    }

    public static String replaceVariables(String value, StringUtil.ReplacementCallback additionalCallback) {
        value = StringUtil.replaceVariable(value, (token, memento, hasFallback) -> {
            if (token.startsWith("installer:")) {
                return LauncherVariables.getInstallerVariable(token.substring("installer:".length()));
            }
            if (token.startsWith("i18n:")) {
                if (messages != null) {
                    return InstallerVariables.replaceI18n(token, messages, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE, hasFallback, arguments -> {
                        for (int i = 0; i < arguments.length; ++i) {
                            arguments[i] = LauncherVariables.replaceVariables(arguments[i], additionalCallback);
                        }
                    });
                }
                return "messages not found";
            }
            if (token.indexOf(58) == -1) {
                return System.getenv().get(token);
            }
            if (additionalCallback != null) {
                return additionalCallback.getReplacement(token, memento, hasFallback);
            }
            return null;
        });
        return value;
    }

    public static Properties replaceVariables(Properties properties) {
        Properties replacedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String value = LauncherVariables.replaceVariables((String)entry.getValue());
            replacedProperties.put(name, value);
        }
        return replacedProperties;
    }

    public static List<String> replaceVariables(List<String> list) {
        ArrayList<String> replacedList = new ArrayList<String>(list.size());
        for (String value : list) {
            replacedList.add(LauncherVariables.replaceVariables(value));
        }
        return replacedList;
    }

    public static String[] init(Class mainClass, String[] args) {
        ArrayList<String> replacedArgs = null;
        if (args != null) {
            replacedArgs = new ArrayList<String>();
            String prefix = "${installer:";
            for (String arg : args) {
                if (arg.startsWith(prefix) && arg.indexOf(125) == arg.length() - 1) {
                    String variableName = arg.substring(prefix.length(), arg.length() - 1);
                    Object variableValue = Variables.getInstallerVariable(variableName);
                    if (variableValue instanceof Object[]) {
                        Object[] variableValues;
                        for (Object valueElement : variableValues = (Object[])variableValue) {
                            LauncherVariables.addIfNotEmpty(replacedArgs, LauncherVariables.replaceVariables(valueElement.toString()));
                        }
                        continue;
                    }
                    replacedArgs.add(LauncherVariables.replaceVariables(arg));
                    continue;
                }
                replacedArgs.add(LauncherVariables.replaceVariables(arg));
            }
        }
        LauncherVariables.replaceSystemProperties(mainClass);
        return replacedArgs == null ? new String[]{} : replacedArgs.toArray(new String[0]);
    }

    private static void addIfNotEmpty(List<String> values, String value) {
        if (value != null && value.length() > 0) {
            values.add(value);
        }
    }

    private static String getInstallerVariable(String variableName) {
        Object value = Variables.getInstallerVariable(variableName);
        if (value == null) {
            return MISSING_REPLACEMENT;
        }
        return value.toString();
    }

    private static void replaceSystemProperties(Class mainClass) {
        Properties systemProperties = System.getProperties();
        ArrayList<String> keyNames = new ArrayList<String>(systemProperties.size());
        for (Object o : systemProperties.keySet()) {
            keyNames.add((String)o);
        }
        for (String keyName : keyNames) {
            String value = LauncherVariables.replaceVariables(System.getProperty(keyName));
            if (Objects.equals(keyName, "java.library.path")) {
                if (mainClass == MacLauncher.class) {
                    String appPackage = System.getProperty("exe4j.moduleName");
                    if (appPackage != null) {
                        value = value.replaceAll(InstallerVariables.quoteRegexpSearch(appPackage + "/..//"), "/");
                        value = value.replaceAll(InstallerVariables.quoteRegexpSearch(appPackage + "/Contents/Resources/app//"), "/");
                    }
                } else if (mainClass == Launcher.class || mainClass == UnixLauncher.class) {
                    String userDir = System.getProperty("user.dir");
                    value = value.replaceAll(InstallerVariables.quoteRegexpSearch(userDir + "//"), "/");
                }
            }
            System.setProperty(keyName, value);
        }
    }

    public static String getApplicationId() throws IOException {
        LauncherVariables.initConfig();
        return applicationId;
    }

    public static String getApplicationVersion() throws IOException {
        LauncherVariables.initConfig();
        return applicationVersion;
    }

    public static String getApplicationName() throws IOException {
        LauncherVariables.initConfig();
        return applicationName;
    }

    private static synchronized void initConfig() throws IOException {
        if (applicationId == null || applicationVersion == null || applicationName == null) {
            InstallerConfig config = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
            applicationId = config.getApplicationId();
            applicationVersion = config.getApplicationVersion();
            applicationName = config.getApplicationName();
        }
    }

    public static void setLanguageId(String languageId) {
        if (languageId != null && !languageId.isEmpty()) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (installerConfig == null) {
                try {
                    installerConfig = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (installerConfig != null) {
                LanguageConfig languageConfig = installerConfig.getLanguageById(languageId);
                if (languageConfig == null && !installerConfig.getLanguages().isEmpty()) {
                    languageConfig = installerConfig.getLanguages().get(0);
                }
                if (languageConfig != null) {
                    try {
                        messages = new LauncherResourceBundleWrapper(Messages.createMessages(languageConfig, installerConfig).getPlainMessages());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static class LauncherResourceBundleWrapper
    extends ResourceBundle {
        private ResourceBundle messages;

        public LauncherResourceBundleWrapper(ResourceBundle messages) {
            this.messages = messages;
        }

        @Override
        @NotNull
        public Enumeration<String> getKeys() {
            return this.messages.getKeys();
        }

        @Override
        protected Object handleGetObject(@NotNull String key) {
            return LauncherVariables.replaceVariables((String)this.messages.getObject(key));
        }
    }
}

