/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.events;

import com.install4j.api.context.Context;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;

public class InstallerVariableEvent
extends InstallerEvent {
    private String variableName;

    public InstallerVariableEvent(Object source, Context context, String variableName) {
        super(source, context, EventType.VARIABLE_CHANGED);
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public String toString() {
        return super.toString() + " [variable " + this.variableName + "]";
    }

    @Override
    public String getVerbose() {
        if (InstallerVariables.getHiddenVariables().contains(this.variableName)) {
            return super.getVerbose() + ": " + this.variableName;
        }
        return super.getVerbose() + ": " + InstallerUtil.getVerboseVariableDefinition(this.variableName, this.getContext().getVariable(this.variableName));
    }
}

