/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MessageBox
implements Runnable,
ActionListener,
WindowListener,
KeyListener {
    private ActionListener listener;
    private Dialog dialog;
    private String closeWindowCommand = "CloseRequested";
    private String title;
    private Frame frame;
    private boolean frameNotProvided;
    private Panel buttonPanel = new Panel();
    private Canvas imageCanvas;
    private boolean block = false;

    public MessageBox(ActionListener listener) {
        this();
        this.listener = listener;
    }

    public MessageBox() {
    }

    @Override
    public void run() {
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        this.dialog.setVisible(false);
        this.dialog.dispose();
        if (this.frameNotProvided) {
            this.frame.dispose();
        }
        if (this.listener != null) {
            this.listener.actionPerformed(evt);
        }
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.fireCloseRequested();
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.fireCloseRequested();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    private void fireCloseRequested() {
        ActionEvent event = new ActionEvent(this, 1001, this.closeWindowCommand);
        this.actionPerformed(event);
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setBlock(boolean v) {
        this.block = v;
    }

    public void setCloseWindowCommand(String command) {
        this.closeWindowCommand = command;
    }

    public void addChoice(String label, String command) {
        Button button = new Button(label);
        button.setActionCommand(command);
        button.addActionListener(this);
        button.addKeyListener(this);
        this.buttonPanel.add(button);
    }

    public void addChoice(String label) {
        this.addChoice(label, label);
    }

    public void ask(String message) {
        if (this.frame == null) {
            this.frame = new Frame();
            this.frameNotProvided = true;
        } else {
            this.frameNotProvided = false;
        }
        this.dialog = new Dialog(this.frame, true);
        this.dialog.addWindowListener(this);
        this.dialog.addKeyListener(this);
        this.dialog.setTitle(this.title);
        this.dialog.setLayout(new BorderLayout(5, 5));
        Panel messagePanel = this.createMultiLinePanel(message);
        if (this.imageCanvas == null) {
            this.dialog.add("Center", messagePanel);
        } else {
            Panel centerPanel = new Panel();
            centerPanel.add(this.imageCanvas);
            centerPanel.add(messagePanel);
            this.dialog.add("Center", centerPanel);
        }
        this.dialog.add("South", this.buttonPanel);
        this.dialog.pack();
        this.enforceMinimumSize(this.dialog, 200, 100);
        this.centerWindow(this.dialog);
        Toolkit.getDefaultToolkit().beep();
        if (this.block) {
            this.run();
        } else {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void askOkay(String message) {
        this.addChoice("Okay");
        this.ask(message);
    }

    public void askYesNo(String message) {
        this.addChoice("Yes");
        this.addChoice("No");
        this.ask(message);
    }

    private Panel createMultiLinePanel(String message) {
        Panel mainPanel = new Panel();
        GridBagLayout gbLayout = new GridBagLayout();
        mainPanel.setLayout(gbLayout);
        this.addMultilineString(message, mainPanel);
        return mainPanel;
    }

    private void addMultilineString(String message, Container container) {
        GridBagConstraints constraints = this.getDefaultConstraints();
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        GridBagLayout gbLayout = (GridBagLayout)container.getLayout();
        while (message.length() > 0) {
            String line;
            int newLineIndex = message.indexOf(10);
            if (newLineIndex >= 0) {
                line = message.substring(0, newLineIndex);
                message = message.substring(newLineIndex + 1);
            } else {
                line = message;
                message = "";
            }
            Label label = new Label(line);
            gbLayout.setConstraints(label, constraints);
            container.add(label);
        }
    }

    private GridBagConstraints getDefaultConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.insets = new Insets(4, 4, 4, 4);
        constraints.fill = 0;
        constraints.anchor = 17;
        return constraints;
    }

    private void centerWindow(Window win) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenDim.width < win.getSize().width) {
            win.setSize(screenDim.width, win.getSize().height);
        }
        if (screenDim.height < win.getSize().height) {
            win.setSize(win.getSize().width, screenDim.height);
        }
        int x = (screenDim.width - win.getSize().width) / 2;
        int y = (screenDim.height - win.getSize().height) / 2;
        win.setLocation(x, y);
    }

    private void enforceMinimumSize(Component comp, int minWidth, int minHeight) {
        if (comp.getSize().width < minWidth) {
            comp.setSize(minWidth, comp.getSize().height);
        }
        if (comp.getSize().height < minHeight) {
            comp.setSize(comp.getSize().width, minHeight);
        }
    }

    public static class Invoker {
        public static void showError(String message) {
            MessageBox messageBox = new MessageBox();
            messageBox.setTitle("Error");
            messageBox.addChoice("OK");
            messageBox.setBlock(true);
            messageBox.ask(message);
        }
    }
}

