var $23a1e93dc7fa8653$exports = require("./useSelect.main.js");
var $ccxQv$react = require("react");
var $ccxQv$reactariautils = require("@react-aria/utils");
var $ccxQv$reactariaform = require("@react-aria/form");
var $ccxQv$reactariainteractions = require("@react-aria/interactions");
var $ccxQv$reactariavisuallyhidden = require("@react-aria/visually-hidden");


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useHiddenSelect", () => $6eae0e0872a4cdd4$export$f809e80f58e251d1);
$parcel$export(module.exports, "HiddenSelect", () => $6eae0e0872a4cdd4$export$cbd84cdb2e668835);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 





function $6eae0e0872a4cdd4$export$f809e80f58e251d1(props, state, triggerRef) {
    let data = (0, $23a1e93dc7fa8653$exports.selectData).get(state) || {};
    let { autoComplete: autoComplete, name: name = data.name, isDisabled: isDisabled = data.isDisabled } = props;
    let { validationBehavior: validationBehavior, isRequired: isRequired } = data;
    let modality = (0, $ccxQv$reactariainteractions.useInteractionModality)();
    let { visuallyHiddenProps: visuallyHiddenProps } = (0, $ccxQv$reactariavisuallyhidden.useVisuallyHidden)();
    (0, $ccxQv$reactariautils.useFormReset)(props.selectRef, state.selectedKey, state.setSelectedKey);
    (0, $ccxQv$reactariaform.useFormValidation)({
        validationBehavior: validationBehavior,
        focus: ()=>triggerRef.current.focus()
    }, state, props.selectRef);
    var _state_selectedKey;
    // In Safari, the <select> cannot have `display: none` or `hidden` for autofill to work.
    // In Firefox, there must be a <label> to identify the <select> whereas other browsers
    // seem to identify it just by surrounding text.
    // The solution is to use <VisuallyHidden> to hide the elements, which clips the elements to a
    // 1px rectangle. In addition, we hide from screen readers with aria-hidden, and make the <select>
    // non tabbable with tabIndex={-1}.
    //
    // In mobile browsers, there are next/previous buttons above the software keyboard for navigating
    // between fields in a form. These only support native form inputs that are tabbable. In order to
    // support those, an additional hidden input is used to marshall focus to the button. It is tabbable
    // except when the button is focused, so that shift tab works properly to go to the actual previous
    // input in the form. Using the <select> for this also works, but Safari on iOS briefly flashes
    // the native menu on focus, so this isn't ideal. A font-size of 16px or greater is required to
    // prevent Safari from zooming in on the input when it is focused.
    //
    // If the current interaction modality is null, then the user hasn't interacted with the page yet.
    // In this case, we set the tabIndex to -1 on the input element so that automated accessibility
    // checkers don't throw false-positives about focusable elements inside an aria-hidden parent.
    return {
        containerProps: {
            ...visuallyHiddenProps,
            'aria-hidden': true,
            ['data-react-aria-prevent-focus']: true,
            ['data-a11y-ignore']: 'aria-hidden-focus'
        },
        inputProps: {
            type: 'text',
            tabIndex: modality == null || state.isFocused || state.isOpen ? -1 : 0,
            style: {
                fontSize: 16
            },
            onFocus: ()=>triggerRef.current.focus(),
            disabled: isDisabled
        },
        selectProps: {
            tabIndex: -1,
            autoComplete: autoComplete,
            disabled: isDisabled,
            required: validationBehavior === 'native' && isRequired,
            name: name,
            value: (_state_selectedKey = state.selectedKey) !== null && _state_selectedKey !== void 0 ? _state_selectedKey : '',
            onChange: (e)=>state.setSelectedKey(e.target.value)
        }
    };
}
function $6eae0e0872a4cdd4$export$cbd84cdb2e668835(props) {
    let { state: state, triggerRef: triggerRef, label: label, name: name, isDisabled: isDisabled } = props;
    let selectRef = (0, $ccxQv$react.useRef)(null);
    let { containerProps: containerProps, inputProps: inputProps, selectProps: selectProps } = $6eae0e0872a4cdd4$export$f809e80f58e251d1({
        ...props,
        selectRef: selectRef
    }, state, triggerRef);
    var _state_selectedKey;
    // If used in a <form>, use a hidden input so the value can be submitted to a server.
    // If the collection isn't too big, use a hidden <select> element for this so that browser
    // autofill will work. Otherwise, use an <input type="hidden">.
    if (state.collection.size <= 300) return /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("div", {
        ...containerProps,
        "data-testid": "hidden-select-container"
    }, /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("input", inputProps), /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("label", null, label, /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("select", {
        ...selectProps,
        ref: selectRef
    }, /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("option", null), [
        ...state.collection.getKeys()
    ].map((key)=>{
        let item = state.collection.getItem(key);
        if (item.type === 'item') return /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("option", {
            key: item.key,
            value: item.key
        }, item.textValue);
    }))));
    else if (name) return /*#__PURE__*/ (0, ($parcel$interopDefault($ccxQv$react))).createElement("input", {
        type: "hidden",
        autoComplete: selectProps.autoComplete,
        name: name,
        disabled: isDisabled,
        value: (_state_selectedKey = state.selectedKey) !== null && _state_selectedKey !== void 0 ? _state_selectedKey : ''
    });
    return null;
}


//# sourceMappingURL=HiddenSelect.main.js.map
