"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSupportedTimeZones = void 0;
var timezones_generated_1 = require("./timezones.generated");
function isSupported(timeZone, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var formatter = new Intl.DateTimeFormat(locale, { timeZone: timeZone });
        return formatter.resolvedOptions().timeZone === timeZone;
    }
    catch (_err) { }
    return false;
}
function getSupportedTimeZones(locale) {
    return timezones_generated_1.timezones.filter(function (timezone) { return isSupported(timezone, locale); });
}
exports.getSupportedTimeZones = getSupportedTimeZones;
