"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Blacklist = void 0;
const media_1 = require("../constants/media");
const datasource_1 = __importDefault(require("../datasource"));
const Media_1 = __importDefault(require("../entity/Media"));
const User_1 = require("../entity/User");
const DbColumnHelper_1 = require("../utils/DbColumnHelper");
const typeorm_1 = require("typeorm");
let Blacklist = class Blacklist {
    constructor(init) {
        Object.assign(this, init);
    }
    static async addToBlacklist({ blacklistRequest, }, entityManager) {
        const em = entityManager ?? datasource_1.default;
        const blacklist = new this({
            ...blacklistRequest,
        });
        const mediaRepository = em.getRepository(Media_1.default);
        let media = await mediaRepository.findOne({
            where: {
                tmdbId: blacklistRequest.tmdbId,
            },
        });
        const blacklistRepository = em.getRepository(this);
        await blacklistRepository.save(blacklist);
        if (!media) {
            media = new Media_1.default({
                tmdbId: blacklistRequest.tmdbId,
                status: media_1.MediaStatus.BLACKLISTED,
                status4k: media_1.MediaStatus.BLACKLISTED,
                mediaType: blacklistRequest.mediaType,
                blacklist: Promise.resolve(blacklist),
            });
            await mediaRepository.save(media);
        }
        else {
            media.blacklist = Promise.resolve(blacklist);
            media.status = media_1.MediaStatus.BLACKLISTED;
            media.status4k = media_1.MediaStatus.BLACKLISTED;
            await mediaRepository.save(media);
        }
    }
};
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Blacklist.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    __metadata("design:type", String)
], Blacklist.prototype, "mediaType", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'varchar' }),
    __metadata("design:type", String)
], Blacklist.prototype, "title", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, typeorm_1.Index)(),
    __metadata("design:type", Number)
], Blacklist.prototype, "tmdbId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => User_1.User, (user) => user.id, {
        eager: true,
    }),
    __metadata("design:type", User_1.User)
], Blacklist.prototype, "user", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => Media_1.default, (media) => media.blacklist, {
        onDelete: 'CASCADE',
    }),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Media_1.default)
], Blacklist.prototype, "media", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'varchar' }),
    __metadata("design:type", String)
], Blacklist.prototype, "blacklistedTags", void 0);
__decorate([
    (0, DbColumnHelper_1.DbAwareColumn)({ type: 'datetime', default: () => 'CURRENT_TIMESTAMP' }),
    __metadata("design:type", Date)
], Blacklist.prototype, "createdAt", void 0);
Blacklist = __decorate([
    (0, typeorm_1.Entity)(),
    (0, typeorm_1.Unique)(['tmdbId']),
    __metadata("design:paramtypes", [Object])
], Blacklist);
exports.Blacklist = Blacklist;
