from typing import Any, Dict, Optional

from .. import ContentLocation

class AttachBase:
    max_detect_buffer_size: int
    unknown_mimetype: str
    unknown_filename: str
    unknown_filename_extension: str
    strict: bool
    max_file_size: int
    location: ContentLocation
    template_args: Dict[str, Any]
    def __init__(
        self,
        name: Optional[str] = ...,
        mimetype: Optional[str] = ...,
        cache: Optional[bool] = ...,
        **kwargs: Any
    ) -> None: ...
    @property
    def path(self) -> Optional[str]: ...
    @property
    def name(self) -> Optional[str]: ...
    @property
    def mimetype(self) -> Optional[str]: ...
    def exists(self) -> bool: ...
    def invalidate(self) -> None: ...
    def download(self) -> bool: ...
    @staticmethod
    def parse_url(
        url: str,
        verify_host: bool = ...
    ) -> Dict[str, Any]: ...
    def __len__(self) -> int: ...
    def __bool__(self) -> bool: ...
