"""empty message

Revision ID: df76a4410347
Revises: 4274a5dfc4ad
Create Date: 2025-11-19 07:36:46.102169

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'df76a4410347'
down_revision = '4274a5dfc4ad'
branch_labels = None
depends_on = None

bind = op.get_context().bind
insp = sa.inspect(bind)


def column_exists(table_name, column_name):
    columns = insp.get_columns(table_name)
    return any(c["name"] == column_name for c in columns)


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if not column_exists('table_episodes', 'absoluteEpisode'):
        with op.batch_alter_table('table_episodes', schema=None) as batch_op:
            batch_op.add_column(sa.Column('absoluteEpisode', sa.INT(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    pass
