# - Config file for rocprofiler-register and its component libraries
# It defines the following variables:
#
# rocprofiler-register_INCLUDE_DIRS
# rocprofiler-register_LIBRARIES
# rocprofiler-register_INTERNAL_DEFINES - used by the test suite

# compute paths
get_filename_component(rocprofiler-register_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# version
include(${CMAKE_CURRENT_LIST_DIR}/rocprofiler-register-config-version.cmake)

set(rocprofiler-register_VERSION ${PACKAGE_VERSION})


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rocprofiler-register-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocprofiler-register_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocprofiler-register_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
get_filename_component(rocprofiler-register_ROOT_DIR ${rocprofiler-register_INCLUDE_DIR} PATH)

if(NOT rocprofiler-register_BUILD_TREE)
    include("${rocprofiler-register_CMAKE_DIR}/rocprofiler-register-library-targets.cmake")
endif()

if(TARGET rocprofiler-register::rocprofiler-register)
    set(rocprofiler-register_LIBRARIES rocprofiler-register::rocprofiler-register)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocprofiler-register
    FOUND_VAR rocprofiler-register_FOUND
    REQUIRED_VARS rocprofiler-register_ROOT_DIR rocprofiler-register_INCLUDE_DIR rocprofiler-register_LIBRARIES
    VERSION_VAR rocprofiler-register_VERSION
    HANDLE_COMPONENTS)
