\name{GradientRecursiveGaussianImageFilter}
\alias{GradientRecursiveGaussianImageFilter}
\title{GradientRecursiveGaussianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the gradient of an image by convolution with the first
derivative of a Gaussian.
GradientRecursiveGaussianImageFilter}
\details{
This filter is implemented using the recursive gaussian filters.
This filter supports both scalar and vector pixel types within the
input image, including VectorImage type.
See:
GradientRecursiveGaussian for the procedural interface
itk::GradientRecursiveGaussianImageFilter for the Doxygen on the original ITK class.
GradientRecursiveGaussianImageFilter}
%C++ includes: sitkGradientRecursiveGaussianImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalizeAcrossScale() const:}{
Define which normalization factor will be used for the Gaussian
See:
RecursiveGaussianImageFilter::SetNormalizeAcrossScale
}
\item{double GetSigma() const:}{
Get the value of Sigma along the first dimension.
}
\item{bool GetUseImageDirection() const:}{
The UseImageDirection flag determines whether the gradients are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the gradients are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.
}
\item{ GradientRecursiveGaussianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self NormalizeAcrossScaleOff():}{}
\item{Self NormalizeAcrossScaleOn():}{
Set the value of NormalizeAcrossScale to true or false respectfully.
}
\item{Self SetNormalizeAcrossScale(bool NormalizeAcrossScale):}{
Define which normalization factor will be used for the Gaussian
See:
RecursiveGaussianImageFilter::SetNormalizeAcrossScale
}
\item{Self SetSigma(double Sigma):}{
Set/Get the Sigma value. Sigma is measured in the units of image
spacing.
}
\item{Self SetUseImageDirection(bool UseImageDirection):}{
The UseImageDirection flag determines whether the gradients are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the gradients are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageDirectionOff():}{}
\item{Self UseImageDirectionOn():}{
Set the value of UseImageDirection to true or false respectfully.
}
\item{ ~GradientRecursiveGaussianImageFilter():}{
Destructor
}
}
}
