/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.ExternallyTaggedUnion;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class MultiBucketBase
implements PlainJsonSerializable {
    @Nonnull
    private final Map<String, Aggregate> aggregations;
    private final long docCount;

    protected MultiBucketBase(AbstractBuilder<?> builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.docCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).docCount, this, "docCount");
    }

    @Nonnull
    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    public final long docCount() {
        return this.docCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        ExternallyTaggedUnion.serializeTypedKeysInner(this.aggregations, generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMultiBucketBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (builder.aggregations == null) {
                builder.aggregations = new HashMap<String, Aggregate>();
            }
            Aggregate._TYPED_KEYS_DESERIALIZER.deserializeEntry((String)name, (JsonParser)parser, (JsonpMapper)mapper, builder.aggregations);
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aggregations);
        result = 31 * result + Long.hashCode(this.docCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiBucketBase other = (MultiBucketBase)o;
        return Objects.equals(this.aggregations, other.aggregations) && this.docCount == other.docCount;
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        private Long docCount;
        @Nullable
        protected Map<String, Aggregate> aggregations;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(MultiBucketBase o) {
            this.aggregations = AbstractBuilder._mapCopy(o.aggregations);
            this.docCount = o.docCount;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.aggregations = AbstractBuilder._mapCopy(o.aggregations);
            this.docCount = o.docCount;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT aggregations(Map<String, Aggregate> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        @Nonnull
        public final BuilderT docCount(long value) {
            this.docCount = value;
            return this.self();
        }
    }
}

