/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.geo.search.aggregations.bucket.composite.GeoTileGridValuesSourceBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoTileGrid;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.opensearch.geo.search.aggregations.metrics.InternalGeoBounds;
import org.opensearch.index.mapper.GeoShapeFieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;

public class GeoModulePlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("geo_shape", new GeoShapeFieldMapper.TypeParser());
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        SearchPlugin.AggregationSpec geoBounds = new SearchPlugin.AggregationSpec("geo_bounds", GeoBoundsAggregationBuilder::new, GeoBoundsAggregationBuilder.PARSER).addResultReader(InternalGeoBounds::new).setAggregatorRegistrar(GeoBoundsAggregationBuilder::registerAggregators);
        SearchPlugin.AggregationSpec geoHashGrid = new SearchPlugin.AggregationSpec("geohash_grid", GeoHashGridAggregationBuilder::new, GeoHashGridAggregationBuilder.PARSER).addResultReader(GeoHashGrid::new).setAggregatorRegistrar(GeoHashGridAggregationBuilder::registerAggregators);
        SearchPlugin.AggregationSpec geoTileGrid = new SearchPlugin.AggregationSpec("geotile_grid", GeoTileGridAggregationBuilder::new, GeoTileGridAggregationBuilder.PARSER).addResultReader(GeoTileGrid::new).setAggregatorRegistrar(GeoTileGridAggregationBuilder::registerAggregators);
        return List.of(geoBounds, geoHashGrid, geoTileGrid);
    }

    public List<SearchPlugin.CompositeAggregationSpec> getCompositeAggregations() {
        return Collections.singletonList(new SearchPlugin.CompositeAggregationSpec(GeoTileGridValuesSourceBuilder::register, GeoTileGridValuesSourceBuilder.class, GeoTileGridValuesSourceBuilder.COMPOSITE_AGGREGATION_SERIALISATION_BYTE_CODE, GeoTileGridValuesSourceBuilder::new, GeoTileGridValuesSourceBuilder::parse, "geotile_grid"));
    }
}

