/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceLifecycle;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFleetError> {
    private static final SdkField<LaunchTemplateAndOverridesResponse> LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateAndOverrides").getter(CreateFleetError.getter(CreateFleetError::launchTemplateAndOverrides)).setter(CreateFleetError.setter(Builder::launchTemplateAndOverrides)).constructor(LaunchTemplateAndOverridesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateAndOverrides").unmarshallLocationName("launchTemplateAndOverrides").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(CreateFleetError.getter(CreateFleetError::lifecycleAsString)).setter(CreateFleetError.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").unmarshallLocationName("lifecycle").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(CreateFleetError.getter(CreateFleetError::errorCode)).setter(CreateFleetError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").unmarshallLocationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(CreateFleetError.getter(CreateFleetError::errorMessage)).setter(CreateFleetError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").unmarshallLocationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD, LIFECYCLE_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFleetError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;
    private final String lifecycle;
    private final String errorCode;
    private final String errorMessage;

    private CreateFleetError(BuilderImpl builder) {
        this.launchTemplateAndOverrides = builder.launchTemplateAndOverrides;
        this.lifecycle = builder.lifecycle;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final LaunchTemplateAndOverridesResponse launchTemplateAndOverrides() {
        return this.launchTemplateAndOverrides;
    }

    public final InstanceLifecycle lifecycle() {
        return InstanceLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateAndOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetError)) {
            return false;
        }
        CreateFleetError other = (CreateFleetError)obj;
        return Objects.equals(this.launchTemplateAndOverrides(), other.launchTemplateAndOverrides()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFleetError").add("LaunchTemplateAndOverrides", (Object)this.launchTemplateAndOverrides()).add("Lifecycle", (Object)this.lifecycleAsString()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateAndOverrides": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateAndOverrides()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LaunchTemplateAndOverrides", LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetError, T> g) {
        return obj -> g.apply((CreateFleetError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;
        private String lifecycle;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetError model) {
            this.launchTemplateAndOverrides(model.launchTemplateAndOverrides);
            this.lifecycle(model.lifecycle);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final LaunchTemplateAndOverridesResponse.Builder getLaunchTemplateAndOverrides() {
            return this.launchTemplateAndOverrides != null ? this.launchTemplateAndOverrides.toBuilder() : null;
        }

        public final void setLaunchTemplateAndOverrides(LaunchTemplateAndOverridesResponse.BuilderImpl launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides != null ? launchTemplateAndOverrides.build() : null;
        }

        @Override
        public final Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(InstanceLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public CreateFleetError build() {
            return new CreateFleetError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFleetError> {
        public Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse var1);

        default public Builder launchTemplateAndOverrides(Consumer<LaunchTemplateAndOverridesResponse.Builder> launchTemplateAndOverrides) {
            return this.launchTemplateAndOverrides((LaunchTemplateAndOverridesResponse)((LaunchTemplateAndOverridesResponse.Builder)LaunchTemplateAndOverridesResponse.builder().applyMutation(launchTemplateAndOverrides)).build());
        }

        public Builder lifecycle(String var1);

        public Builder lifecycle(InstanceLifecycle var1);

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

