/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert.ext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509PolicyInformation;
import oracle.security.pki.util.Utils;

public class CertificatePoliciesExtension
extends X509Extension {
    private static final ASN1ObjectID f = PKIX.R;
    private ArrayList<X509PolicyInformation> g;

    public CertificatePoliciesExtension() {
        super(f);
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation) {
        this(x509PolicyInformation, false);
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation, boolean bl) {
        super(f, bl);
        this.g = new ArrayList();
        this.g.add(x509PolicyInformation);
        this.a(this.f());
    }

    public CertificatePoliciesExtension(List<X509PolicyInformation> list) {
        this(list, false);
    }

    public CertificatePoliciesExtension(List<X509PolicyInformation> list, boolean bl) {
        super(f, bl);
        this.g = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<X509PolicyInformation>(list));
        this.a(this.f());
    }

    public CertificatePoliciesExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void a(X509PolicyInformation x509PolicyInformation) {
        if (this.g == null) {
            this.g = new ArrayList();
        }
        this.g.add(x509PolicyInformation);
        this.a(this.f());
    }

    public ArrayList<X509PolicyInformation> e() {
        if (!this.e) {
            this.g();
        }
        return this.g;
    }

    private byte[] f() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.g));
        this.e = true;
        return byArray;
    }

    private void g() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.d());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(byteArrayInputStream);
            this.g = new ArrayList();
            while (aSN1SequenceInputStream.a()) {
                this.g.add(new X509PolicyInformation(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.b();
            if (this.g.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.e = true;
    }

    @Override
    public String toString() {
        if (!this.e) {
            this.g();
        }
        StringBuffer stringBuffer = new StringBuffer("certificatePoliciesExtension {oid = " + f.d() + ", critical = " + this.c() + ", value = [");
        if (this.e() != null) {
            stringBuffer.append("certificatePolicies = {");
            boolean bl = false;
            int n = this.e().size();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.e().get(i).toString());
                bl = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

