/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.text.converter.GDKMessage;

public abstract class CharacterConverterMSOLISO2022JPBase
extends CharacterConverter12Byte {
    protected static int MAXLIMIT = 65536;
    static final int BUCKETSIZE = 200;
    static final byte REPLACEMENT_CHAR_IN_BYTE = 63;
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{63};
    static final int ASCII_JISROMAN = 0;
    static final int JISX0208 = 1;
    static final int JISX0212 = 2;
    static final int HALF_WIDTH_KATAKANA = 3;
    static final byte[] JISROMAN_ESCSEQ = new byte[]{27, 40, 66};
    static final byte[] JISX0208_ESCSEQ = new byte[]{27, 36, 66};
    static final byte[] JISX0212_ESCSEQ = new byte[]{27, 36, 40, 68};
    static final byte[] HALF_WIDTH_KATAKANA_ESCSEQ = new byte[]{27, 40, 73};
    static final int FULLWIDTH_MODE = 1;
    static final int HALFWIDTH_MODE = 2;
    public int[] m_oraCharExtraLevel1 = null;
    public char[] m_oraCharExtraLevel2 = null;

    public CharacterConverterMSOLISO2022JPBase() {
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 10.0f;
    }

    @Override
    int toUnicode(int n) throws SQLException {
        return n;
    }

    @Override
    int toUnicodeWithReplacement(int n) {
        if (n >= 0 && n <= 127) {
            return n;
        }
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = this.m_ucsCharLevel1[n2] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] : this.m_ucsCharReplacement;
        return n4;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            return this.toUnicodeStringMain(byArray, n, n2, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            return this.toUnicodeStringMain(byArray, n, n2, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            char[] cArray = new char[]{(char)this.m_ucsCharReplacement};
            return new String(cArray);
        }
    }

    private String toUnicodeStringMain(byte[] byArray, int n, int n2, CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        int n3 = n;
        int n4 = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = new String("");
        n4 = this.getNextEscpSeq(byArray, n3);
        if (n4 == -1) {
            string = string + this.toUnicodeChars(byArray, 0, byArray.length - 1, 0, characterConverterBehavior);
            bl5 = true;
        } else if (n4 != 0) {
            string = string + this.toUnicodeChars(byArray, 0, n4 - 1, 0, characterConverterBehavior);
        }
        while (!bl5) {
            int n5;
            n3 = n4;
            if ((n4 = this.getNextEscpSeq(byArray, n4 + 1)) == -1) {
                n4 = byArray.length;
                bl5 = true;
            }
            if ((n5 = this.checkEscpSeq(byArray, n3)) == 0 || n5 == 1 || n5 == 3) {
                if (n3 + 3 == n4) continue;
                string = string + this.toUnicodeChars(byArray, n3 + 3, n4 - 1, n5, characterConverterBehavior);
                continue;
            }
            if (n5 == 2) {
                if (n3 + 4 == n4) continue;
                string = string + this.toUnicodeChars(byArray, n3 + 4, n4 - 1, n5, characterConverterBehavior);
                continue;
            }
            characterConverterBehavior.onFailConversion(n3);
        }
        return string;
    }

    private String toUnicodeChars(byte[] byArray, int n, int n2, int n3, CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        String string;
        block5: {
            block4: {
                string = new String("");
                if (n2 < n) {
                    throw new SQLException();
                }
                if (n3 == 0) {
                    return new String(byArray, n, n2 - n + 1);
                }
                if (n3 != 1 && n3 != 2) break block4;
                for (int i = n; i < n2; i += 2) {
                    int n4 = byArray[i] & 0xFF;
                    int n5 = byArray[i + 1] & 0xFF;
                    int n6 = this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] : this.m_ucsCharReplacement;
                    string = string + new String(new char[]{(char)n6});
                }
                break block5;
            }
            if (n3 != 3) break block5;
            for (int i = n; i <= n2; ++i) {
                int n7 = 0;
                int n8 = byArray[i] & 0xFF;
                int n9 = this.m_ucsCharLevel1[n7] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] : this.m_ucsCharReplacement;
                string = string + new String(new char[]{(char)n9});
            }
        }
        return string;
    }

    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int[] nArray = new int[]{string.length()};
        if (nArray[0] == 0) {
            return new byte[0];
        }
        char[] cArray = new char[nArray[0]];
        string.getChars(0, nArray[0], cArray, 0);
        return this.toISO2022JPStringMain(cArray, 0, null, 0, nArray, CharacterConverterBehavior.REPORT_ERROR);
    }

    @Override
    public byte[] toOracleStringWithReplacement(char[] cArray, int n, byte[] byArray, int n2, int[] nArray) {
        try {
            return this.toISO2022JPStringMain(cArray, n, byArray, n2, nArray, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public abstract byte[] toISO2022JPStringMain(char[] var1, int var2, byte[] var3, int var4, int[] var5, CharacterConverterBehavior var6) throws SQLException;

    public byte[] toISO2022JPStringFWHW(char[] cArray, int n, byte[] byArray, int n2, int[] nArray, CharacterConverterBehavior characterConverterBehavior, int n3) throws SQLException {
        byte[] byArray2;
        int n4;
        int n5;
        int n6;
        int n7 = nArray[0];
        int n8 = n + n7;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(0);
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        byte[] byArray3 = new byte[200];
        arrayList.add(byArray3);
        for (int i = n; i < n8; ++i) {
            if (cArray[i] >= '\u0000' && cArray[i] <= '\u007f') {
                if (n9 != 0) {
                    n9 = 0;
                    n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                    n10 += 3;
                }
                n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{(byte)cArray[i]});
                ++n10;
                continue;
            }
            if (cArray[i] >= '\u00a1' && cArray[i] <= '\u00ff') {
                n6 = cArray[i] >> 8 & 0xFF;
                n5 = cArray[i] & 0xFF;
                if (this.m_oraCharExtraLevel1[n6] == -1 || this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n6] + n5] == '\uffff') continue;
                n4 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n6] + n5];
                if ((char)(n4 & 0xFF) == n4) {
                    if (n9 != 0) {
                        n9 = 0;
                        n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                        n10 += 3;
                    }
                    n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{(byte)(n4 & 0xFF)});
                    ++n10;
                    continue;
                }
                if (n9 != 1) {
                    n9 = 1;
                    n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                    n10 += 3;
                }
                n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{(byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)});
                n10 += 2;
                continue;
            }
            n6 = cArray[i] >> 8 & 0xFF;
            n5 = cArray[i] & 0xFF;
            if (this.m_oraCharExtraLevel1[n6] != -1 && this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n6] + n5] != '\uffff') {
                if (n3 == 1) {
                    if (n9 != 1) {
                        n9 = 1;
                        n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                        n10 += 3;
                    }
                    n4 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n6] + n5];
                    n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{(byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)});
                    n10 += 2;
                    continue;
                }
                if (n9 != 3) {
                    n9 = 3;
                    n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                    n10 += 3;
                }
                n4 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n6] + n5];
                n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{(byte)(n4 & 0xFF)});
                ++n10;
                continue;
            }
            if (this.m_oraCharLevel1[n6] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n5] != '\uffff') {
                if (n9 != 1) {
                    n9 = 1;
                    n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                    n10 += 3;
                }
                n4 = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n5];
                n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{(byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)});
                n10 += 2;
                continue;
            }
            if (characterConverterBehavior == CharacterConverterBehavior.REPLACEMENT) {
                if (n9 != 0) {
                    n9 = 0;
                    n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, n9);
                    n10 += 3;
                }
                n4 = this.m_1ByteOraCharReplacement;
                n11 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n11, arrayList, new byte[]{63});
                ++n10;
                continue;
            }
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        if (n9 != 0) {
            n11 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n11, arrayList, 0);
            n10 += 3;
        }
        if (byArray != null) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n10];
            n2 = 0;
        }
        n6 = 0;
        n5 = n2;
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            int n12 = (n10 - n5) / 200 > 0 ? 200 : n10 % 200;
            n6 = 0;
            while (n6 < n12) {
                byArray2[n5] = ((byte[])arrayList.get(n4))[n6];
                ++n6;
                ++n5;
            }
        }
        nArray[0] = n10;
        return byArray2;
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharExtraLevel1 = new int[256];
        char[] cArray = new char[MAXLIMIT];
        int n4 = 0;
        int[][] nArray = new int[MAXLIMIT][2];
        int n5 = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            this.m_oraCharLevel1[n3] = -1;
        }
        for (n3 = 0; n3 < MAXLIMIT; ++n3) {
            cArray[n3] = 65535;
        }
        for (n3 = 0; n3 < 65535; ++n3) {
            int n6 = this.toUnicodeWithReplacement(n3);
            if (n6 == this.m_ucsCharReplacement) continue;
            nArray[n5][0] = n6;
            nArray[n5][1] = n3;
            ++n5;
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3][0] >>> 8 & 0xFF;
            n = nArray[n3][0] & 0xFF;
            if (this.m_oraCharLevel1[n2] == -1) {
                this.m_oraCharLevel1[n2] = n4;
                n4 += 256;
            }
            if (cArray[this.m_oraCharLevel1[n2] + n] != '\uffff') continue;
            cArray[this.m_oraCharLevel1[n2] + n] = (char)(nArray[n3][1] & 0xFFFF);
        }
        this.m_oraCharLevel2 = new char[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.m_oraCharLevel2[n3] = cArray[n3];
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n4 = 0;
            for (n3 = 0; n3 < 256; ++n3) {
                this.m_oraCharExtraLevel1[n3] = -1;
            }
            for (n3 = 0; n3 < MAXLIMIT; ++n3) {
                cArray[n3] = 65535;
            }
            int n7 = this.extraUnicodeToOracleMapping.length;
            for (n3 = 0; n3 < n7; ++n3) {
                int n8 = this.extraUnicodeToOracleMapping[n3][0];
                int n9 = this.extraUnicodeToOracleMapping[n3][1];
                n2 = n8 >>> 8 & 0xFF;
                n = n8 & 0xFF;
                if (this.m_oraCharExtraLevel1[n2] == -1) {
                    this.m_oraCharExtraLevel1[n2] = n4;
                    n4 += 256;
                }
                if (cArray[this.m_oraCharExtraLevel1[n2] + n] != '\uffff') continue;
                cArray[this.m_oraCharExtraLevel1[n2] + n] = (char)n9;
            }
            this.m_oraCharExtraLevel2 = new char[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.m_oraCharExtraLevel2[n3] = cArray[n3];
            }
        }
    }

    @Override
    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    @Override
    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    @Override
    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    @Override
    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    private static int insertToBucket(int n, ArrayList arrayList, byte[] byArray) {
        if (n + byArray.length - 1 >= 200) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n >= 200) {
                    byte[] byArray2 = new byte[200];
                    arrayList.add(byArray2);
                    n = 0;
                }
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n] = byArray[n2];
                ++n2;
                ++n;
            }
        } else {
            int n3 = 0;
            while (n3 < byArray.length) {
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n] = byArray[n3];
                ++n3;
                ++n;
            }
        }
        return n;
    }

    private int checkEscpSeq(byte[] byArray, int n) throws SQLException {
        if (n + 2 >= byArray.length) {
            return -1;
        }
        if (byArray[n + 1] == 40) {
            if (byArray[n + 2] == 66 || byArray[n + 2] == 74) {
                return 0;
            }
            if (byArray[n + 2] == 73) {
                return 3;
            }
        } else if (byArray[n + 1] == 36) {
            if (byArray[n + 2] == 64 || byArray[n + 2] == 66) {
                return 1;
            }
            if (byArray[n + 2] == 40 && byArray[n + 3] == 68) {
                return 2;
            }
        }
        return -1;
    }

    private static int insertEscSeq(int n, ArrayList arrayList, int n2) {
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = JISROMAN_ESCSEQ;
        } else if (n2 == 1) {
            byArray = JISX0208_ESCSEQ;
        } else if (n2 == 2) {
            byArray = JISX0212_ESCSEQ;
        } else if (n2 == 3) {
            byArray = HALF_WIDTH_KATAKANA_ESCSEQ;
        }
        return CharacterConverterMSOLISO2022JPBase.insertToBucket(n, arrayList, byArray);
    }

    private int getNextEscpSeq(byte[] byArray, int n) {
        while (n < byArray.length) {
            if (byArray[n] == 27) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static abstract class CharacterConverterBehavior {
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior(){

            @Override
            public void onFailConversion(int n) throws SQLException {
                throw new SQLException();
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior(){

            @Override
            public void onFailConversion(int n) throws SQLException {
            }
        };

        public abstract void onFailConversion(int var1) throws SQLException;
    }
}

