/*
 * Decompiled with CFR 0.152.
 */
package airsquared.JMacNotification;

import airsquared.JMacNotification.NSObject;
import airsquared.JMacNotification.natives.NSTypes;
import com.sun.jna.Pointer;
import java.time.LocalDateTime;

public class NSDateComponents
implements NSObject {
    private Pointer pointer;

    public NSDateComponents() {
        this.pointer = NSTypes.newNSDateComponents();
    }

    public NSDateComponents(Pointer p) {
        this.pointer = p;
    }

    public static NSDateComponents fromLocalDateTime(LocalDateTime localDateTime) {
        NSDateComponents dateComponents = new NSDateComponents();
        dateComponents.setDay(localDateTime.getDayOfMonth());
        dateComponents.setMonth(localDateTime.getMonthValue());
        dateComponents.setYear(localDateTime.getYear());
        dateComponents.setHour(localDateTime.getHour());
        dateComponents.setMinute(localDateTime.getMinute());
        dateComponents.setSecond(localDateTime.getSecond());
        return dateComponents;
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
    }

    public Pointer toNSDate() {
        return NSTypes.toNSDate(this.getPointer());
    }

    public int getDay() {
        return NSTypes.getDay(this.pointer);
    }

    public void setDay(int day) {
        NSTypes.setDay(this.pointer, day);
    }

    public int getMonth() {
        return NSTypes.getMonth(this.pointer);
    }

    public void setMonth(int month) {
        NSTypes.setMonth(this.pointer, month);
    }

    public int getYear() {
        return NSTypes.getYear(this.pointer);
    }

    public void setYear(int year) {
        NSTypes.setYear(this.pointer, year);
    }

    public int getHour() {
        return NSTypes.getHour(this.pointer);
    }

    public void setHour(int hour) {
        NSTypes.setHour(this.pointer, hour);
    }

    public int getMinute() {
        return NSTypes.getMinute(this.pointer);
    }

    public void setMinute(int minute) {
        NSTypes.setMinute(this.pointer, minute);
    }

    public int getSecond() {
        return NSTypes.getSecond(this.pointer);
    }

    public void setSecond(int second) {
        NSTypes.setSecond(this.pointer, second);
    }

    @Override
    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public String nativeType() {
        return "NSDateComponents";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pointer) {
            return NSTypes.isEqual(this.pointer, (Pointer)obj);
        }
        if (obj instanceof NSObject) {
            return NSTypes.isEqual(this.pointer, ((NSObject)obj).getPointer());
        }
        return false;
    }

    public int hashCode() {
        return NSTypes.hash(this.pointer);
    }
}

