/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;

class MultiIndexMergeScheduler
extends MergeScheduler {
    private final Directory directory;
    private final CombinedMergeScheduler combinedMergeScheduler;
    private final boolean manageSingleton;

    public MultiIndexMergeScheduler(Directory directory) {
        this.directory = directory;
        this.combinedMergeScheduler = CombinedMergeScheduler.acquireSingleton();
        this.manageSingleton = true;
    }

    MultiIndexMergeScheduler(Directory directory, CombinedMergeScheduler combinedMergeScheduler) {
        this.directory = directory;
        this.combinedMergeScheduler = combinedMergeScheduler;
        this.manageSingleton = false;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public CombinedMergeScheduler getCombinedMergeScheduler() {
        return this.combinedMergeScheduler;
    }

    @Override
    public void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
        CombinedMergeScheduler.TaggedMergeSource taggedMergeSource = new CombinedMergeScheduler.TaggedMergeSource(mergeSource, this.directory);
        this.combinedMergeScheduler.merge(taggedMergeSource, trigger);
    }

    @Override
    public Directory wrapForMerge(MergePolicy.OneMerge merge, Directory in) {
        return this.combinedMergeScheduler.wrapForMerge(merge, in);
    }

    @Override
    public void close() throws IOException {
        this.combinedMergeScheduler.sync(this.directory);
        if (this.manageSingleton) {
            CombinedMergeScheduler.releaseSingleton();
        }
    }

    public void setInfoStream(InfoStream infoStream) {
        this.combinedMergeScheduler.setInfoStream(infoStream);
    }

    static class CombinedMergeScheduler
    extends ConcurrentMergeScheduler {
        private static CombinedMergeScheduler singleton = null;
        private static int singletonRefCount = 0;

        CombinedMergeScheduler() {
        }

        private static synchronized CombinedMergeScheduler acquireSingleton() {
            if (singleton == null) {
                singleton = new CombinedMergeScheduler();
            }
            ++singletonRefCount;
            return singleton;
        }

        private static synchronized void releaseSingleton() throws IOException {
            if (singletonRefCount < 1) {
                throw new IllegalStateException("decrementSingletonReference() called too many times");
            }
            if (--singletonRefCount == 0) {
                singleton.close();
                singleton = null;
            }
        }

        public static synchronized CombinedMergeScheduler peekSingleton() {
            return singleton;
        }

        public void setInfoStream(InfoStream infoStream) {
            this.infoStream = infoStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync(Directory directory) {
            block12: {
                boolean interrupted = false;
                block8: while (true) {
                    while (true) {
                        Thread toSync = null;
                        CombinedMergeScheduler combinedMergeScheduler = this;
                        synchronized (combinedMergeScheduler) {
                            for (ConcurrentMergeScheduler.MergeThread t : this.mergeThreads) {
                                if (!t.isAlive() || t == Thread.currentThread() || !(t.mergeSource instanceof TaggedMergeSource) || !((TaggedMergeSource)t.mergeSource).getDirectory().equals(directory)) continue;
                                toSync = t;
                                break;
                            }
                        }
                        if (toSync == null) break block12;
                        try {
                            toSync.join();
                            continue block8;
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        static class TaggedMergeSource
        implements MergeScheduler.MergeSource {
            private final MergeScheduler.MergeSource in;
            private final Directory directory;

            TaggedMergeSource(MergeScheduler.MergeSource in, Directory directory) {
                this.in = in;
                this.directory = directory;
            }

            public Directory getDirectory() {
                return this.directory;
            }

            @Override
            public MergePolicy.OneMerge getNextMerge() {
                return this.in.getNextMerge();
            }

            @Override
            public void onMergeFinished(MergePolicy.OneMerge merge) {
                this.in.onMergeFinished(merge);
            }

            @Override
            public boolean hasPendingMerges() {
                return this.in.hasPendingMerges();
            }

            @Override
            public void merge(MergePolicy.OneMerge merge) throws IOException {
                this.in.merge(merge);
            }
        }
    }
}

