/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ImageStack extends Image3D {

	public ImageStack(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the number of rows in each image of this image3d
	 *
	 * @return number of rows
	 * @throws Lib3MFException
	 */
	public int getRowCount() throws Lib3MFException {
		Pointer bufferRowCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_getrowcount.invokeInt(new java.lang.Object[]{mHandle, bufferRowCount}));
		return bufferRowCount.getInt(0);
	}

	/**
	 * Sets the number of rows in each image of this image3d
	 *
	 * @param rowCount number of rows
	 * @throws Lib3MFException
	 */
	public void setRowCount(int rowCount) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_setrowcount.invokeInt(new java.lang.Object[]{mHandle, rowCount}));
	}

	/**
	 * Retrieves the number of columns in each image of this image3d
	 *
	 * @return number of columns
	 * @throws Lib3MFException
	 */
	public int getColumnCount() throws Lib3MFException {
		Pointer bufferColumnCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_getcolumncount.invokeInt(new java.lang.Object[]{mHandle, bufferColumnCount}));
		return bufferColumnCount.getInt(0);
	}

	/**
	 * Sets the number of columns in each image of this image3d
	 *
	 * @param columnCount number of columns
	 * @throws Lib3MFException
	 */
	public void setColumnCount(int columnCount) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_setcolumncount.invokeInt(new java.lang.Object[]{mHandle, columnCount}));
	}

	/**
	 * Retrieves the number of images in the stack.
	 *
	 * @return number of images
	 * @throws Lib3MFException
	 */
	public int getSheetCount() throws Lib3MFException {
		Pointer bufferSheetCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_getsheetcount.invokeInt(new java.lang.Object[]{mHandle, bufferSheetCount}));
		return bufferSheetCount.getInt(0);
	}

	/**
	 * Retrieves a sheet of the stack. Raises an error if sheet is not set.
	 *
	 * @param index index of the image (0-based)
	 * @return attachment containing the image
	 * @throws Lib3MFException
	 */
	public Attachment getSheet(int index) throws Lib3MFException {
		Pointer bufferSheet = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_getsheet.invokeInt(new java.lang.Object[]{mHandle, index, bufferSheet}));
		Pointer valueSheet = bufferSheet.getPointer(0);
		Attachment sheet = null;
		if (valueSheet == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Sheet was a null pointer");
		}
		sheet = mWrapper.PolymorphicFactory(valueSheet, Attachment.class);
		return sheet;
	}

	/**
	 * Sets a sheet to an existing attachment.
	 *
	 * @param index index of the image (0-based)
	 * @param sheet attachment containing the image
	 * @throws Lib3MFException
	 */
	public void setSheet(int index, Attachment sheet) throws Lib3MFException {
		Pointer sheetHandle = null;
		if (sheet != null) {
			sheetHandle = sheet.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Sheet is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_setsheet.invokeInt(new java.lang.Object[]{mHandle, index, sheetHandle}));
	}

	/**
	 * Creates a new sheet attachment with empty data.
	 *
	 * @param index index of the image (0-based)
	 * @param path path of part in the package
	 * @return attachment containing the image
	 * @throws Lib3MFException
	 */
	public Attachment createEmptySheet(int index, String path) throws Lib3MFException {
		byte[] bytesPath = path.getBytes(StandardCharsets.UTF_8);
		Memory bufferPath = new Memory(bytesPath.length + 1);
		bufferPath.write(0, bytesPath, 0, bytesPath.length);
		bufferPath.setByte(bytesPath.length, (byte)0);
		Pointer bufferSheet = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_createemptysheet.invokeInt(new java.lang.Object[]{mHandle, index, bufferPath, bufferSheet}));
		Pointer valueSheet = bufferSheet.getPointer(0);
		Attachment sheet = null;
		if (valueSheet == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Sheet was a null pointer");
		}
		sheet = mWrapper.PolymorphicFactory(valueSheet, Attachment.class);
		return sheet;
	}

	/**
	 * Creates a new sheet attachment from a memory buffer.
	 *
	 * @param index index of the image (0-based)
	 * @param path path of part in the package
	 * @param data binary image data
	 * @return attachment containing the image
	 * @throws Lib3MFException
	 */
	public Attachment createSheetFromBuffer(int index, String path, byte[] data) throws Lib3MFException {
		byte[] bytesPath = path.getBytes(StandardCharsets.UTF_8);
		Memory bufferPath = new Memory(bytesPath.length + 1);
		bufferPath.write(0, bytesPath, 0, bytesPath.length);
		bufferPath.setByte(bytesPath.length, (byte)0);
		Pointer bufferData = new Memory(Math.max(1, 1 * data.length));
		for (int i = 0; i < data.length; i++) {
		  bufferData.setByte(1 * i, data[i]);
		}
		Pointer bufferSheet = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_createsheetfrombuffer.invokeInt(new java.lang.Object[]{mHandle, index, bufferPath, (long) data.length, bufferData, bufferSheet}));
		Pointer valueSheet = bufferSheet.getPointer(0);
		Attachment sheet = null;
		if (valueSheet == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Sheet was a null pointer");
		}
		sheet = mWrapper.PolymorphicFactory(valueSheet, Attachment.class);
		return sheet;
	}

	/**
	 * Creates a new sheet attachment from a file on disk.
	 *
	 * @param index index of the image (0-based)
	 * @param path path of part in the package
	 * @param fileName file name to read from
	 * @return attachment containing the image
	 * @throws Lib3MFException
	 */
	public Attachment createSheetFromFile(int index, String path, String fileName) throws Lib3MFException {
		byte[] bytesPath = path.getBytes(StandardCharsets.UTF_8);
		Memory bufferPath = new Memory(bytesPath.length + 1);
		bufferPath.write(0, bytesPath, 0, bytesPath.length);
		bufferPath.setByte(bytesPath.length, (byte)0);
		byte[] bytesFileName = fileName.getBytes(StandardCharsets.UTF_8);
		Memory bufferFileName = new Memory(bytesFileName.length + 1);
		bufferFileName.write(0, bytesFileName, 0, bytesFileName.length);
		bufferFileName.setByte(bytesFileName.length, (byte)0);
		Pointer bufferSheet = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_imagestack_createsheetfromfile.invokeInt(new java.lang.Object[]{mHandle, index, bufferPath, bufferFileName, bufferSheet}));
		Pointer valueSheet = bufferSheet.getPointer(0);
		Attachment sheet = null;
		if (valueSheet == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Sheet was a null pointer");
		}
		sheet = mWrapper.PolymorphicFactory(valueSheet, Attachment.class);
		return sheet;
	}


}

