/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Writer extends Base {

	public Writer(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Writes out the model as file. The file type is specified by the Model Writer class.
	 *
	 * @param filename Filename to write into
	 * @throws Lib3MFException
	 */
	public void writeToFile(String filename) throws Lib3MFException {
		byte[] bytesFilename = filename.getBytes(StandardCharsets.UTF_8);
		Memory bufferFilename = new Memory(bytesFilename.length + 1);
		bufferFilename.write(0, bytesFilename, 0, bytesFilename.length);
		bufferFilename.setByte(bytesFilename.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_writetofile.invokeInt(new java.lang.Object[]{mHandle, bufferFilename}));
	}

	/**
	 * Retrieves the size of the full 3MF file stream.
	 *
	 * @return the stream size
	 * @throws Lib3MFException
	 */
	public long getStreamSize() throws Lib3MFException {
		Pointer bufferStreamSize = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_getstreamsize.invokeInt(new java.lang.Object[]{mHandle, bufferStreamSize}));
		return bufferStreamSize.getLong(0);
	}

	/**
	 * Writes out the 3MF file into a memory buffer
	 *
	 * @return buffer to write into
	 * @throws Lib3MFException
	 */
	public byte[] writeToBuffer() throws Lib3MFException {
		Pointer countNeededBuffer = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_writetobuffer.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededBuffer, Pointer.NULL}));
		long countBuffer = countNeededBuffer.getLong(0);
		Pointer bufferBuffer = new Memory(Math.max(1, 1 * countBuffer));
		mWrapper.checkError(this, mWrapper.lib3mf_writer_writetobuffer.invokeInt(new java.lang.Object[]{mHandle, countBuffer, countNeededBuffer, bufferBuffer}));
		return bufferBuffer.getByteArray(0, (int)countBuffer);
	}

	/**
	 * Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
	 *
	 * @param theWriteCallback Callback to call for writing a data chunk
	 * @param theSeekCallback Callback to call for seeking in the stream
	 * @param userData Userdata that is passed to the callback function
	 * @throws Lib3MFException
	 */
	public void writeToCallback(Lib3MFWrapper.WriteCallback theWriteCallback, Lib3MFWrapper.SeekCallback theSeekCallback, Pointer userData) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_writer_writetocallback.invokeInt(new java.lang.Object[]{mHandle, theWriteCallback, theSeekCallback, userData}));
	}

	/**
	 * Set the progress callback for calls to this writer
	 *
	 * @param progressCallback pointer to the callback function.
	 * @param userData pointer to arbitrary user data that is passed without modification to the callback.
	 * @throws Lib3MFException
	 */
	public void setProgressCallback(Lib3MFWrapper.ProgressCallback progressCallback, Pointer userData) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_writer_setprogresscallback.invokeInt(new java.lang.Object[]{mHandle, progressCallback, userData}));
	}

	/**
	 * Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
	 *
	 * @return The number of digits to be written in each vertex coordinate-value after the decimal point.
	 * @throws Lib3MFException
	 */
	public int getDecimalPrecision() throws Lib3MFException {
		Pointer bufferDecimalPrecision = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_getdecimalprecision.invokeInt(new java.lang.Object[]{mHandle, bufferDecimalPrecision}));
		return bufferDecimalPrecision.getInt(0);
	}

	/**
	 * Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
	 *
	 * @param decimalPrecision The number of digits to be written in each vertex coordinate-value after the decimal point.
	 * @throws Lib3MFException
	 */
	public void setDecimalPrecision(int decimalPrecision) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_writer_setdecimalprecision.invokeInt(new java.lang.Object[]{mHandle, decimalPrecision}));
	}

	/**
	 * Activates (deactivates) the strict mode of the reader.
	 *
	 * @param strictModeActive flag whether strict mode is active or not.
	 * @throws Lib3MFException
	 */
	public void setStrictModeActive(boolean strictModeActive) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_writer_setstrictmodeactive.invokeInt(new java.lang.Object[]{mHandle, strictModeActive}));
	}

	/**
	 * Queries whether the strict mode of the reader is active or not
	 *
	 * @return returns flag whether strict mode is active or not.
	 * @throws Lib3MFException
	 */
	public boolean getStrictModeActive() throws Lib3MFException {
		Pointer bufferStrictModeActive = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_getstrictmodeactive.invokeInt(new java.lang.Object[]{mHandle, bufferStrictModeActive}));
		return bufferStrictModeActive.getByte(0) != 0;
	}

	/**
	 * Returns Warning and Error Information of the read process
	 *
	 * @param index Index of the Warning. Valid values are 0 to WarningCount - 1
	 * @return GetWarning Result Tuple
	 * @throws Lib3MFException
	 */
	public GetWarningResult getWarning(int index) throws Lib3MFException {
		Pointer bufferErrorCode = new Memory(4);
		Pointer bytesNeededWarning = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_getwarning.invokeInt(new java.lang.Object[]{mHandle, index, bufferErrorCode, 0, bytesNeededWarning, null}));
		int sizeWarning = bytesNeededWarning.getInt(0);
		Pointer bufferWarning = new Memory(sizeWarning);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_getwarning.invokeInt(new java.lang.Object[]{mHandle, index, bufferErrorCode, sizeWarning, bytesNeededWarning, bufferWarning}));
		GetWarningResult returnTuple = new GetWarningResult();
		returnTuple.ErrorCode = bufferErrorCode.getInt(0);
		returnTuple.Warning = new String(bufferWarning.getByteArray(0, sizeWarning - 1), StandardCharsets.UTF_8);
		return returnTuple;
	}

	public static class GetWarningResult {
		/**
		 * filled with the error code of the warning
		 */
		public int ErrorCode;

		/**
		 * the message of the warning
		 */
		public String Warning;

	}
	/**
	 * Returns Warning and Error Count of the read process
	 *
	 * @return filled with the count of the occurred warnings.
	 * @throws Lib3MFException
	 */
	public int getWarningCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_getwarningcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * Registers a callback to deal with data key encryption/decryption from keystore
	 *
	 * @param consumerID The ConsumerID to register for
	 * @param theCallback The callback to be callede for wrapping and encryption key
	 * @param userData Userdata that is passed to the callback function
	 * @throws Lib3MFException
	 */
	public void addKeyWrappingCallback(String consumerID, Lib3MFWrapper.KeyWrappingCallback theCallback, Pointer userData) throws Lib3MFException {
		byte[] bytesConsumerID = consumerID.getBytes(StandardCharsets.UTF_8);
		Memory bufferConsumerID = new Memory(bytesConsumerID.length + 1);
		bufferConsumerID.write(0, bytesConsumerID, 0, bytesConsumerID.length);
		bufferConsumerID.setByte(bytesConsumerID.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_writer_addkeywrappingcallback.invokeInt(new java.lang.Object[]{mHandle, bufferConsumerID, theCallback, userData}));
	}

	/**
	 * Registers a callback to deal with encryption of content
	 *
	 * @param theCallback The callback used to encrypt content
	 * @param userData Userdata that is passed to the callback function
	 * @throws Lib3MFException
	 */
	public void setContentEncryptionCallback(Lib3MFWrapper.ContentEncryptionCallback theCallback, Pointer userData) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_writer_setcontentencryptioncallback.invokeInt(new java.lang.Object[]{mHandle, theCallback, userData}));
	}


}

