/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;

public final class SPopFunction<K, V>
implements SetBucketBaseFunction<K, V, Collection<V>> {
    public static final AdvancedExternalizer<SPopFunction> EXTERNALIZER = new Externalizer();
    private final long count;
    private final boolean remove;

    public SPopFunction(long count, boolean remove) {
        this.count = count;
        this.remove = remove;
    }

    public Collection<V> apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (this.count == 0L || existing.isEmpty()) {
            return Collections.emptyList();
        }
        SetBucket s = (SetBucket)existing.get();
        if (this.count > 0L) {
            Collection popped = SPopFunction.getRandomSubset(s.toList(), this.count);
            if (this.remove) {
                SetBucket.SetBucketResult result = s.removeAll(popped);
                if ((s = result.bucket()).isEmpty()) {
                    entryView.remove();
                } else {
                    entryView.set(s, new MetaParam.Writable[0]);
                }
            }
            return popped;
        }
        List list = s.toList();
        return ThreadLocalRandom.current().ints(-this.count, 0, s.size()).mapToObj(list::get).collect(Collectors.toList());
    }

    public static <T> Collection<T> getRandomSubset(List<T> list, long count) {
        if ((long)list.size() <= count) {
            return list;
        }
        Collections.shuffle(list);
        return list.stream().limit(count).collect(Collectors.toList());
    }

    private static class Externalizer
    implements AdvancedExternalizer<SPopFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SPopFunction>> getTypeClasses() {
            return Collections.singleton(SPopFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_POP_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SPopFunction object) throws IOException {
            output.writeLong(object.count);
            output.writeBoolean(object.remove);
        }

        public SPopFunction<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long count = input.readLong();
            boolean remove = input.readBoolean();
            return new SPopFunction(count, remove);
        }
    }
}

