/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Objects;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedRoot
extends SqmRoot
implements SqmTreatedFrom {
    private final SqmRoot wrappedPath;
    private final SqmEntityDomainType treatTarget;

    public SqmTreatedRoot(SqmRoot wrappedPath, SqmEntityDomainType treatTarget) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName()), (EntityDomainType)((Object)wrappedPath.getReferencedPathSource()), null, (NodeBuilder)wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    private SqmTreatedRoot(NavigablePath navigablePath, SqmRoot wrappedPath, SqmEntityDomainType treatTarget) {
        super(navigablePath, (EntityDomainType)((Object)wrappedPath.getReferencedPathSource()), null, (NodeBuilder)wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedRoot copy(SqmCopyContext context) {
        SqmTreatedRoot existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedRoot path = context.registerCopy(this, new SqmTreatedRoot(this.getNavigablePath(), (SqmRoot)this.wrappedPath.copy(context), this.treatTarget));
        this.copyTo(path, context);
        return path;
    }

    public EntityDomainType getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType getManagedType() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmBindableType getNodeType() {
        return this.treatTarget;
    }

    public SqmEntityDomainType getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.wrappedPath.getLhs();
    }

    public Object accept(SemanticQueryWalker walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedRoot)) return false;
        SqmTreatedRoot that = (SqmTreatedRoot)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getName(), that.treatTarget.getName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.wrappedPath.getNavigablePath(), this.treatTarget.getName());
    }
}

