/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.values.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.generator.values.internal.GeneratedValuesImpl;
import org.hibernate.generator.values.internal.GeneratedValuesMappingProducer;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.NaturalIdHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.results.internal.TableGroupImpl;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.jdbc.internal.DirectResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;

@Internal
public class GeneratedValuesHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(IdentifierGeneratorHelper.class);

    public static GeneratedValues getGeneratedValues(ResultSet resultSet, PreparedStatement statement, EntityPersister persister, EventType timing, SharedSessionContractImplementor session) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        GeneratedValuesMappingProducer mappingProducer = (GeneratedValuesMappingProducer)persister.getMutationDelegate(timing == EventType.INSERT ? MutationType.INSERT : MutationType.UPDATE).getGeneratedValuesMappingProducer();
        List<GeneratedValueBasicResultBuilder> resultBuilders = mappingProducer.getResultBuilders();
        ArrayList<BasicValuedModelPart> generatedProperties = new ArrayList<BasicValuedModelPart>(resultBuilders.size());
        for (GeneratedValueBasicResultBuilder resultBuilder : resultBuilders) {
            generatedProperties.add(resultBuilder.getModelPart());
        }
        GeneratedValuesImpl generatedValues = new GeneratedValuesImpl(generatedProperties);
        Object[] results = GeneratedValuesHelper.readGeneratedValues(resultSet, statement, persister, mappingProducer, session);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted generated values for entity " + MessageHelper.infoString(persister) + ": " + ArrayHelper.toString(results));
        }
        for (int i = 0; i < results.length; ++i) {
            generatedValues.addGeneratedValue((ModelPart)generatedProperties.get(i), results[i]);
        }
        return generatedValues;
    }

    private static Object[] readGeneratedValues(ResultSet resultSet, PreparedStatement statement, EntityPersister persister, JdbcValuesMappingProducer mappingProducer, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        BaseExecutionContext executionContext = new BaseExecutionContext(session);
        DirectResultSetAccess directResultSetAccess = new DirectResultSetAccess(session, statement, resultSet);
        LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
        JdbcValuesResultSetImpl jdbcValues = new JdbcValuesResultSetImpl(directResultSetAccess, null, null, QueryOptions.NONE, true, mappingProducer.resolve(directResultSetAccess, influencers, factory), null, executionContext);
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, JdbcValuesSourceProcessingOptions.NO_OPTIONS);
        RowReader<Object[]> rowReader = ResultsHelper.createRowReader(factory, RowTransformerArrayImpl.instance(), Object[].class, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        Object results = ListResultsConsumer.instance(ListResultsConsumer.UniqueSemantic.NONE).consume((JdbcValues)jdbcValues, session, JdbcValuesSourceProcessingOptions.NO_OPTIONS, valuesProcessingState, rowProcessingState, (RowReader)rowReader);
        if (results.isEmpty()) {
            throw new HibernateException("The database returned no natively generated values : " + persister.getNavigableRole().getFullPath());
        }
        return (Object[])results.get(0);
    }

    public static GeneratedValuesMappingProducer createMappingProducer(EntityPersister persister, EventType timing, boolean supportsArbitraryValues, boolean supportsRowId) {
        return GeneratedValuesHelper.generatedValuesMappingProducer(persister, supportsArbitraryValues, GeneratedValuesHelper.getActualGeneratedModelParts(persister, timing, supportsArbitraryValues, supportsRowId));
    }

    private static GeneratedValuesMappingProducer generatedValuesMappingProducer(EntityPersister persister, boolean supportsArbitraryValues, List<? extends ModelPart> generatedProperties) {
        NavigablePath parentNavigablePath = new NavigablePath(persister.getEntityName());
        TableGroupImpl tableGroup = new TableGroupImpl(parentNavigablePath, null, new NamedTableReference("t", "t"), persister);
        GeneratedValuesMappingProducer mappingProducer = new GeneratedValuesMappingProducer();
        for (int i = 0; i < generatedProperties.size(); ++i) {
            ModelPart modelPart = generatedProperties.get(i);
            BasicValuedModelPart basicModelPart = modelPart.asBasicValuedModelPart();
            if (basicModelPart == null) {
                throw new UnsupportedOperationException("Unsupported generated ModelPart: " + modelPart.getPartName());
            }
            mappingProducer.addResultBuilder(new GeneratedValueBasicResultBuilder(parentNavigablePath.append(basicModelPart.getSelectableName()), basicModelPart, tableGroup, supportsArbitraryValues ? Integer.valueOf(i) : null));
        }
        return mappingProducer;
    }

    public static BasicValuedModelPart getActualGeneratedModelPart(BasicValuedModelPart modelPart) {
        return modelPart.isEntityIdentifierMapping() ? modelPart.findContainingEntityMapping().getRootEntityDescriptor().getIdentifierMapping().asBasicValuedModelPart() : modelPart;
    }

    private static List<? extends ModelPart> getActualGeneratedModelParts(EntityPersister persister, EventType timing, boolean supportsArbitraryValues, boolean supportsRowId) {
        if (timing == EventType.INSERT) {
            List<? extends ModelPart> generatedProperties;
            List<? extends ModelPart> list = generatedProperties = supportsArbitraryValues ? persister.getInsertGeneratedProperties() : List.of(persister.getIdentifierMapping());
            if (persister.getRowIdMapping() != null && supportsRowId) {
                ArrayList<? extends ModelPart> newList = new ArrayList<ModelPart>(generatedProperties.size() + 1);
                newList.addAll(generatedProperties);
                newList.add(persister.getRowIdMapping());
                return Collections.unmodifiableList(newList);
            }
            return generatedProperties;
        }
        return persister.getUpdateGeneratedProperties();
    }

    public static GeneratedValuesMutationDelegate getGeneratedValuesDelegate(EntityPersister persister, EventType timing) {
        SessionFactoryImplementor factory = persister.getFactory();
        List<? extends ModelPart> generatedProperties = persister.getGeneratedProperties(timing);
        boolean hasFormula = generatedProperties.stream().anyMatch(part -> {
            SelectableMapping selectable;
            return part instanceof SelectableMapping && (selectable = (SelectableMapping)((Object)part)).isFormula();
        });
        boolean hasRowId = timing == EventType.INSERT && persister.getRowIdMapping() != null;
        Dialect dialect = factory.getJdbcServices().getDialect();
        if (hasRowId && dialect.supportsInsertReturning() && dialect.supportsInsertReturningRowId() && GeneratedValuesHelper.noCustomSql(persister, timing)) {
            return new InsertReturningDelegate(persister, timing);
        }
        if (generatedProperties.isEmpty()) {
            return null;
        }
        if (!hasFormula && dialect.supportsInsertReturningGeneratedKeys() && factory.getSessionFactoryOptions().isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate(persister, false, timing);
        }
        if (GeneratedValuesHelper.supportsReturning(dialect, timing) && GeneratedValuesHelper.noCustomSql(persister, timing)) {
            return new InsertReturningDelegate(persister, timing);
        }
        if (timing == EventType.INSERT && persister.getNaturalIdentifierProperties() != null && !persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            return new UniqueKeySelectingDelegate(persister, NaturalIdHelper.getNaturalIdPropertyNames(persister), timing);
        }
        return null;
    }

    private static boolean supportsReturning(Dialect dialect, EventType timing) {
        return timing == EventType.INSERT ? dialect.supportsInsertReturning() : dialect.supportsUpdateReturning();
    }

    public static boolean noCustomSql(EntityPersister persister, EventType timing) {
        EntityTableMapping identifierTable = persister.getIdentifierTableMapping();
        TableMapping.MutationDetails mutationDetails = timing == EventType.INSERT ? identifierTable.getInsertDetails() : identifierTable.getUpdateDetails();
        return mutationDetails.getCustomSql() == null;
    }
}

