/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import org.keycloak.protocol.oidc.utils.OIDCResponseType;

public enum OIDCResponseMode {
    QUERY("query"),
    JWT("jwt"),
    FRAGMENT("fragment"),
    FORM_POST("form_post"),
    QUERY_JWT("query.jwt"),
    FRAGMENT_JWT("fragment.jwt"),
    FORM_POST_JWT("form_post.jwt");

    private String value;

    private OIDCResponseMode(String v) {
        this.value = v;
    }

    public static OIDCResponseMode parse(String responseMode, OIDCResponseType responseType) {
        if (responseMode == null) {
            return OIDCResponseMode.getDefaultResponseMode(responseType);
        }
        if (responseMode.equals("jwt")) {
            return OIDCResponseMode.getDefaultJarmResponseMode(responseType);
        }
        return OIDCResponseMode.fromValue(responseMode);
    }

    public static OIDCResponseMode parseWhenInvalidResponseType(String responseMode) {
        if (responseMode == null) {
            return QUERY;
        }
        if (responseMode.equals("jwt")) {
            return QUERY_JWT;
        }
        for (OIDCResponseMode c : OIDCResponseMode.values()) {
            if (!c.value.equals(responseMode)) continue;
            return c;
        }
        return QUERY;
    }

    public String value() {
        return this.value;
    }

    private static OIDCResponseMode fromValue(String v) {
        for (OIDCResponseMode c : OIDCResponseMode.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    private static OIDCResponseMode getDefaultResponseMode(OIDCResponseType responseType) {
        if (responseType.isImplicitOrHybridFlow()) {
            return FRAGMENT;
        }
        return QUERY;
    }

    private static OIDCResponseMode getDefaultJarmResponseMode(OIDCResponseType responseType) {
        if (responseType.isImplicitOrHybridFlow()) {
            return FRAGMENT_JWT;
        }
        return QUERY_JWT;
    }
}

