/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl.verifier;

import io.github.dmlloyd.classfile.Attributes;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.attribute.LocalVariableInfo;
import io.github.dmlloyd.classfile.attribute.LocalVariableTableAttribute;
import io.github.dmlloyd.classfile.attribute.StackMapTableAttribute;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPool;
import io.github.dmlloyd.classfile.constantpool.DynamicConstantPoolEntry;
import io.github.dmlloyd.classfile.constantpool.MemberRefEntry;
import io.github.dmlloyd.classfile.constantpool.NameAndTypeEntry;
import io.github.dmlloyd.classfile.constantpool.PoolEntry;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.BoundAttribute;
import io.github.dmlloyd.classfile.impl.CodeImpl;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class VerificationWrapper {
    private final ClassModel clm;
    private final ConstantPoolWrapper cp;

    public VerificationWrapper(ClassModel clm) {
        this.clm = clm;
        this.cp = new ConstantPoolWrapper(clm.constantPool());
    }

    String thisClassName() {
        return this.clm.thisClass().asInternalName();
    }

    int majorVersion() {
        return this.clm.majorVersion();
    }

    String superclassName() {
        return this.clm.superclass().map(ClassEntry::asInternalName).orElse(null);
    }

    Iterable<String> interfaceNames() {
        return Util.mappedList(this.clm.interfaces(), ClassEntry::asInternalName);
    }

    Iterable<MethodWrapper> methods() {
        return this.clm.methods().stream().map(m -> new MethodWrapper((MethodModel)m)).toList();
    }

    boolean findField(String name, String sig) {
        for (FieldModel f : this.clm.fields()) {
            if (!f.fieldName().stringValue().equals(name) || !f.fieldType().stringValue().equals(sig)) continue;
            return true;
        }
        return false;
    }

    static class ConstantPoolWrapper {
        private final ConstantPool cp;

        ConstantPoolWrapper(ConstantPool cp) {
            this.cp = cp;
        }

        int entryCount() {
            return this.cp.size();
        }

        String classNameAt(int index) {
            return this.cp.entryByIndex(index, ClassEntry.class).asInternalName();
        }

        String dynamicConstantSignatureAt(int index) {
            return this.cp.entryByIndex(index, DynamicConstantPoolEntry.class).type().stringValue();
        }

        int tagAt(int index) {
            return this.cp.entryByIndex(index).tag();
        }

        private NameAndTypeEntry _refNameType(int index) {
            NameAndTypeEntry nameAndTypeEntry;
            PoolEntry e = this.cp.entryByIndex(index);
            if (e instanceof DynamicConstantPoolEntry) {
                DynamicConstantPoolEntry de = (DynamicConstantPoolEntry)e;
                nameAndTypeEntry = de.nameAndType();
            } else {
                nameAndTypeEntry = e != null ? ((MemberRefEntry)e).nameAndType() : null;
            }
            return nameAndTypeEntry;
        }

        String refNameAt(int index) {
            return this._refNameType(index).name().stringValue();
        }

        String refSignatureAt(int index) {
            return this._refNameType(index).type().stringValue();
        }

        int refClassIndexAt(int index) {
            return this.cp.entryByIndex(index, MemberRefEntry.class).owner().index();
        }
    }

    class MethodWrapper {
        final MethodModel m;
        private final CodeImpl c;
        private final List<int[]> exc;

        MethodWrapper(MethodModel m) {
            this.m = m;
            this.c = m.code().orElse(null);
            this.exc = new LinkedList<int[]>();
            if (this.c != null) {
                this.c.iterateExceptionHandlers((start, end, handler, catchType) -> this.exc.add(new int[]{start, end, handler, catchType}));
            }
        }

        ConstantPoolWrapper constantPool() {
            return VerificationWrapper.this.cp;
        }

        boolean isNative() {
            return this.m.flags().has(AccessFlag.NATIVE);
        }

        boolean isAbstract() {
            return this.m.flags().has(AccessFlag.ABSTRACT);
        }

        boolean isBridge() {
            return this.m.flags().has(AccessFlag.BRIDGE);
        }

        boolean isStatic() {
            return this.m.flags().has(AccessFlag.STATIC);
        }

        String name() {
            return this.m.methodName().stringValue();
        }

        int maxStack() {
            return this.c == null ? 0 : this.c.maxStack();
        }

        int maxLocals() {
            return this.c == null ? 0 : this.c.maxLocals();
        }

        String descriptor() {
            return this.m.methodType().stringValue();
        }

        String parameters() {
            return this.m.methodTypeSymbol().parameterList().stream().map(ClassDesc::displayName).collect(Collectors.joining(","));
        }

        int codeLength() {
            return this.c == null ? 0 : this.c.codeLength();
        }

        byte[] codeArray() {
            return this.c == null ? null : this.c.codeArray();
        }

        List<int[]> exceptionTable() {
            return this.exc;
        }

        List<LocalVariableInfo> localVariableTable() {
            Optional<LocalVariableTableAttribute> attro = this.c.findAttribute(Attributes.localVariableTable());
            return attro.map(lvta -> lvta.localVariables()).orElse(List.of());
        }

        byte[] stackMapTableRawData() {
            Optional<StackMapTableAttribute> attro = this.c.findAttribute(Attributes.stackMapTable());
            return attro.map(attr -> ((BoundAttribute)((Object)attr)).contents()).orElse(null);
        }
    }
}

