/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorArgumentType<T>
implements ArgumentType<T> {
    private Class<T> type_;

    public ConstructorArgumentType(Class<T> type) {
        this.type_ = type;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        T obj = null;
        try {
            obj = this.type_.getConstructor(String.class).newInstance(value);
        }
        catch (InstantiationException e) {
            this.handleInstatiationError(e);
        }
        catch (IllegalAccessException e) {
            this.handleInstatiationError(e);
        }
        catch (InvocationTargetException e) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "could not convert '%s' to %s (%s)", value, this.type_.getSimpleName(), e.getCause().getMessage()), e.getCause(), parser, arg);
        }
        catch (NoSuchMethodException e) {
            this.handleInstatiationError(e);
        }
        return obj;
    }

    private void handleInstatiationError(Exception e) {
        throw new IllegalArgumentException("Failed to instantiate object", e);
    }
}

