/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.BooleanConditionUnit;
import io.sf.carte.doc.style.css.parser.MediaQueryHelper;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.Objects;

class MediaFeaturePredicateUnit
extends BooleanConditionUnit.Predicate
implements MediaFeaturePredicate {
    private static final long serialVersionUID = 2L;
    private LexicalUnit value1 = null;
    private LexicalUnit value2 = null;
    private byte rangeType;

    MediaFeaturePredicateUnit(String featureName) {
        super(featureName);
    }

    @Override
    public int getPredicateType() {
        return 1;
    }

    @Override
    public void setRangeType(byte rangeType) {
        this.rangeType = rangeType;
    }

    @Override
    public byte getRangeType() {
        return this.rangeType;
    }

    @Override
    public void setValue(LexicalUnit value) {
        this.value1 = value;
    }

    @Override
    public void setValueRange(LexicalUnit value1, LexicalUnit value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    @Override
    public void appendText(StringBuilder buf) {
        String text1 = this.value1 != null ? this.value1.toString() : null;
        String text2 = this.value2 != null ? this.value2.toString() : null;
        MediaQueryHelper.appendFeatureText(ParseHelper.escape(this.getName()), this.rangeType, text1, text2, buf);
    }

    @Override
    public void appendMinifiedText(StringBuilder buf) {
        String text1 = this.value1 != null ? this.value1.toString() : null;
        String text2 = this.value2 != null ? this.value2.toString() : null;
        MediaQueryHelper.appendMinifiedFeatureText(ParseHelper.escape(this.getName()), this.rangeType, text1, text2, buf);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        byte efftype = this.rangeType == 0 ? (byte)1 : this.rangeType;
        return 31 * result + Objects.hash(this.getName(), efftype, this.value1, this.value2);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MediaFeaturePredicateUnit other = (MediaFeaturePredicateUnit)obj;
        byte efftype = this.rangeType == 0 ? (byte)1 : this.rangeType;
        byte otherefftype = other.rangeType == 0 ? (byte)1 : other.rangeType;
        return Objects.equals(this.getName(), other.getName()) && efftype == otherefftype && Objects.equals(this.value1, other.value1) && Objects.equals(this.value2, other.value2);
    }
}

