/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.freeplane.view.swing.map.outline.BlockPanel;
import org.freeplane.view.swing.map.outline.OutlineBlockViewCache;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineVisibleBlockRange;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;
import org.freeplane.view.swing.map.outline.VisibleOutlineNodes;

class OutlineBlockLayout {
    private final OutlineBlockViewCache blockCache;
    private final VisibleOutlineNodes visibleState;
    private OutlineGeometry geometry;
    private final int blockSize;
    private final ScrollableTreePanel treePanel;
    private int cachedMaxWidth = 0;

    OutlineBlockLayout(OutlineBlockViewCache blockCache, VisibleOutlineNodes visibleState, OutlineGeometry geometry, int blockSize, ScrollableTreePanel treePanel) {
        this.blockCache = blockCache;
        this.visibleState = visibleState;
        this.geometry = geometry;
        this.blockSize = blockSize;
        this.treePanel = treePanel;
    }

    void updateGeometry(OutlineGeometry geometry) {
        this.geometry = geometry;
        this.resetCachedMaxWidth();
    }

    void updateVisibleBlocks(JPanel owner, OutlineVisibleBlockRange range, int panelWidth) {
        for (int b = range.getFirstBlock(); b <= range.getLastBlock(); ++b) {
            if (this.blockCache.has(b)) continue;
            this.createBlock(owner, b, panelWidth);
        }
        owner.repaint();
    }

    void removeBlocksFromBlockIndex(JPanel owner, int startBlock) {
        ArrayList<Integer> indices = new ArrayList<Integer>(this.blockCache.keySet());
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            if (idx < startBlock) continue;
            BlockPanel p = this.blockCache.get(idx);
            if (p != null) {
                owner.remove(p);
            }
            this.blockCache.remove(idx);
        }
    }

    void updateBlockPreferredSize(JPanel owner) {
        int visibleNodeCount = this.visibleState.getVisibleNodeCount();
        int height = (visibleNodeCount + 1) * this.geometry.rowHeight;
        Dimension preferredSize = new Dimension(this.cachedMaxWidth, height);
        owner.setPreferredSize(preferredSize);
        for (BlockPanel panel : this.blockCache.blockPanels()) {
            panel.setSize(this.cachedMaxWidth, panel.getHeight());
        }
    }

    private void createBlock(JPanel owner, int blockIndex, int panelWidth) {
        int start = blockIndex * this.blockSize;
        int end = Math.min(start + this.blockSize, this.visibleState.getVisibleNodeCount());
        ArrayList<TreeNode> blockNodes = new ArrayList<TreeNode>();
        for (int i = start; i < end; ++i) {
            TreeNode n = this.visibleState.getNodeAtVisibleIndex(i);
            if (n == null) continue;
            blockNodes.add(n);
        }
        BlockPanel bp = new BlockPanel(blockNodes, this.geometry.rowHeight, this.geometry.outlineTextOrientation, this.treePanel, this.treePanel.getOutlineSelection());
        bp.setComponentOrientation(this.geometry.outlineTextOrientation);
        Rectangle bounds = this.calculateBlockBounds(blockIndex, this.blockSize, panelWidth);
        bp.setBounds(bounds);
        owner.add(bp);
        this.blockCache.put(blockIndex, bp);
        boolean rightToLeft = this.geometry.isRightToLeft();
        for (Component comp : bp.getComponents()) {
            int rightEdge;
            if (!(comp instanceof JButton)) continue;
            int n = rightEdge = rightToLeft ? panelWidth - comp.getX() : comp.getX() + comp.getWidth();
            if (rightEdge <= this.cachedMaxWidth) continue;
            this.cachedMaxWidth = rightEdge;
        }
    }

    private Rectangle calculateBlockBounds(int blockIndex, int blockSize, int panelWidth) {
        int start = blockIndex * blockSize;
        int end = Math.min(start + blockSize, this.visibleState.getVisibleNodeCount());
        int visibleNodesInBlock = end - start;
        int rowHeight = this.geometry.rowHeight;
        int blockY = start * rowHeight;
        int blockHeight = visibleNodesInBlock * rowHeight;
        return new Rectangle(0, blockY, panelWidth, blockHeight);
    }

    void recordButtonRightEdge(int rightEdge) {
        if (rightEdge > this.cachedMaxWidth) {
            this.cachedMaxWidth = rightEdge;
        }
    }

    void resetCachedMaxWidth() {
        this.cachedMaxWidth = 0;
    }

    void removeBlocksOutsideRange(JPanel owner, OutlineVisibleBlockRange range) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int idx : this.blockCache.keySet()) {
            if (idx >= range.getFirstBlock() && idx <= range.getLastBlock()) continue;
            BlockPanel p = this.blockCache.get(idx);
            if (p != null) {
                owner.remove(p);
            }
            toRemove.add(idx);
        }
        for (int idx : toRemove) {
            this.blockCache.remove(idx);
        }
    }
}

