/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.cli;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.AbstractRootCommandLineParameterHandler;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.translate.SQLQueryTranslator;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import picocli.CommandLine;

@CommandLine.Command(name="translateSQL", aliases={"-translateSQL", "-translate-sql-script"}, description={"Translate SQL script from one dialect to another"})
public class SQLTranslatorHandler
extends AbstractRootCommandLineParameterHandler {
    private static final Log log = Log.getLog(SQLTranslatorHandler.class);
    @CommandLine.Parameters(index="0", description={"Parameter in the form dialect=filePath"}, arity="1")
    private String value;

    public void run() {
        String script;
        String[] args = this.value.split(",");
        if (args.length != 2) {
            throw new IllegalStateException("Input parameter format: dialect,<input-file-path>");
        }
        String dialect = args[0];
        String inputFile = args[1];
        if (CommonUtils.isEmpty((String)inputFile)) {
            throw new IllegalStateException("Input file not specified");
        }
        SimplePreferenceStore preferenceStore = new SimplePreferenceStore(this){

            public void save() throws IOException {
            }
        };
        preferenceStore.setValue("sql.format.formatter", "default");
        try (FileReader fr = new FileReader(inputFile);){
            script = IOUtils.readToString((Reader)fr);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening input file " + inputFile, e);
        }
        BasicSQLDialect srcDialect = new BasicSQLDialect(this){};
        BasicSQLDialect targetDialect = new BasicSQLDialect(this){};
        String result = null;
        try {
            result = SQLQueryTranslator.translateScript((SQLDialect)srcDialect, (SQLDialect)targetDialect, (DBPPreferenceStore)preferenceStore, (String)script);
        }
        catch (Exception e) {
            throw new RuntimeException("Error translating file " + inputFile, e);
        }
        System.out.println(result);
    }
}

