/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.project;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class LocalProjectImpl
extends BaseProjectImpl {
    @NotNull
    protected Path projectPath;

    public LocalProjectImpl(@NotNull DBPWorkspace workspace, @Nullable SMSessionContext sessionContext, @NotNull Path projectPath) {
        super(workspace, sessionContext);
        this.projectPath = projectPath;
    }

    public boolean isVirtual() {
        return false;
    }

    @NotNull
    public String getName() {
        Object projectName = this.getProjectProperty("name");
        if (projectName != null) {
            return projectName.toString();
        }
        return this.projectPath.getFileName().toString();
    }

    @NotNull
    public Path getAbsolutePath() {
        return this.projectPath;
    }

    public boolean isOpen() {
        return true;
    }

    public void ensureOpen() {
    }

    public boolean isUseSecretStorage() {
        return false;
    }

    public Path getMetadataFilePath() {
        return this.getMetadataPath().resolve("project-metadata.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveResourcePropertiesBatch(@NotNull Collection<Pair<String, String>> oldToNewPaths) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            for (Pair<String, String> pathsPair : oldToNewPaths) {
                String oldResourcePath = CommonUtils.normalizeResourcePath((String)((String)pathsPair.getFirst()));
                String newResourcePath = CommonUtils.normalizeResourcePath((String)((String)pathsPair.getSecond()));
                Map resProps = (Map)this.resourceProperties.remove(oldResourcePath);
                if (resProps == null) continue;
                this.resourceProperties.put(newResourcePath, resProps);
            }
        }
        this.flushMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetResourcesPropertiesBatch(@NotNull Collection<String> resourcesPaths) {
        this.loadMetadata();
        boolean propertiesChanged = false;
        Object object = this.metadataSync;
        synchronized (object) {
            for (String resourcePath : resourcesPaths) {
                Map removedProperties = (Map)this.resourceProperties.remove(CommonUtils.normalizeResourcePath((String)resourcePath));
                if (removedProperties == null) continue;
                propertiesChanged = true;
            }
        }
        if (propertiesChanged) {
            this.flushMetadata();
        }
        return propertiesChanged;
    }

    public boolean canUpdateProjectName() {
        return false;
    }

    @NotNull
    protected DBPDataSourceRegistry createDataSourceRegistry() {
        return new DataSourceRegistry((DBPProject)this);
    }

    public void setAbsolutePath(@NotNull Path projectPath) {
        this.projectPath = projectPath;
    }
}

