/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OracleDBLink
extends OracleSchemaObject {
    private static final Log log = Log.getLog(OracleDBLink.class);
    private String userName;
    private String host;
    private Date created;

    protected OracleDBLink(DBRProgressMonitor progressMonitor, OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DB_LINK"), true);
        this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USERNAME");
        this.host = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HOST");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
    }

    @Property(viewable=true, editable=true, order=2)
    public String getUserName() {
        return this.userName;
    }

    @Property(viewable=true, editable=true, order=3)
    public String getHost() {
        return this.host;
    }

    @Property(viewable=true, order=4)
    public Date getCreated() {
        return this.created;
    }

    public static Object resolveObject(DBRProgressMonitor monitor, OracleSchema schema, String dbLink) throws DBException {
        if (CommonUtils.isEmpty((String)dbLink)) {
            return null;
        }
        OracleDBLink object = (OracleDBLink)schema.dbLinkCache.getObject(monitor, schema, dbLink);
        if (object == null) {
            log.warn((Object)("DB Link '" + dbLink + "' not found in schema '" + schema.getName() + "'"));
            return dbLink;
        }
        return object;
    }
}

