/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.Variables;
import proguard.evaluation.value.Value;

public class TracedVariables
extends Variables {
    public static final int NONE = -1;
    private Value producerValue;
    private Variables producerVariables;

    public TracedVariables(int size) {
        super(size);
        this.producerVariables = new Variables(size);
    }

    public TracedVariables(TracedVariables tracedVariables) {
        super(tracedVariables);
        this.producerVariables = new Variables(tracedVariables.producerVariables);
    }

    public void setProducerValue(Value producerValue) {
        this.producerValue = producerValue;
    }

    public Value getProducerValue(int index) {
        return this.producerVariables.getValue(index);
    }

    public void setProducerValue(int index, Value value) {
        this.producerVariables.store(index, value);
    }

    @Override
    public void reset(int size) {
        super.reset(size);
        this.producerVariables.reset(size);
    }

    public void initialize(TracedVariables other) {
        super.initialize(other);
        this.producerVariables.initialize(other.producerVariables);
    }

    public boolean generalize(TracedVariables other, boolean clearConflictingOtherVariables) {
        boolean variablesChanged = super.generalize(other, clearConflictingOtherVariables);
        boolean producersChanged = this.producerVariables.generalize(other.producerVariables, clearConflictingOtherVariables);
        if (variablesChanged) {
            for (int index = 0; index < this.size; ++index) {
                if (this.values[index] != null) continue;
                this.producerVariables.values[index] = null;
                if (!clearConflictingOtherVariables) continue;
                other.producerVariables.values[index] = null;
            }
        }
        return variablesChanged || producersChanged;
    }

    @Override
    public void store(int index, Value value) {
        super.store(index, value);
        this.producerVariables.store(index, this.producerValue);
        if (value.isCategory2()) {
            this.producerVariables.store(index + 1, this.producerValue);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedVariables other = (TracedVariables)object;
        return super.equals(object) && this.producerVariables.equals(other.producerVariables);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.producerVariables.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.size(); ++index) {
            Value value = this.values[index];
            Value producerValue = this.producerVariables.getValue(index);
            buffer = buffer.append('[').append(producerValue == null ? "empty:" : producerValue.toString()).append(value == null ? "empty" : value.toString()).append(']');
        }
        return buffer.toString();
    }
}

