﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/MetadataTransferJobProgress.h>
#include <aws/iottwinmaker/model/MetadataTransferJobStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {
class CancelMetadataTransferJobResult {
 public:
  AWS_IOTTWINMAKER_API CancelMetadataTransferJobResult() = default;
  AWS_IOTTWINMAKER_API CancelMetadataTransferJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTTWINMAKER_API CancelMetadataTransferJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The metadata transfer job Id.</p>
   */
  inline const Aws::String& GetMetadataTransferJobId() const { return m_metadataTransferJobId; }
  template <typename MetadataTransferJobIdT = Aws::String>
  void SetMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    m_metadataTransferJobIdHasBeenSet = true;
    m_metadataTransferJobId = std::forward<MetadataTransferJobIdT>(value);
  }
  template <typename MetadataTransferJobIdT = Aws::String>
  CancelMetadataTransferJobResult& WithMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    SetMetadataTransferJobId(std::forward<MetadataTransferJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  CancelMetadataTransferJobResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Used to update the DateTime property.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateDateTime() const { return m_updateDateTime; }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  void SetUpdateDateTime(UpdateDateTimeT&& value) {
    m_updateDateTimeHasBeenSet = true;
    m_updateDateTime = std::forward<UpdateDateTimeT>(value);
  }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  CancelMetadataTransferJobResult& WithUpdateDateTime(UpdateDateTimeT&& value) {
    SetUpdateDateTime(std::forward<UpdateDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's status.</p>
   */
  inline const MetadataTransferJobStatus& GetStatus() const { return m_status; }
  template <typename StatusT = MetadataTransferJobStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = MetadataTransferJobStatus>
  CancelMetadataTransferJobResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's progress.</p>
   */
  inline const MetadataTransferJobProgress& GetProgress() const { return m_progress; }
  template <typename ProgressT = MetadataTransferJobProgress>
  void SetProgress(ProgressT&& value) {
    m_progressHasBeenSet = true;
    m_progress = std::forward<ProgressT>(value);
  }
  template <typename ProgressT = MetadataTransferJobProgress>
  CancelMetadataTransferJobResult& WithProgress(ProgressT&& value) {
    SetProgress(std::forward<ProgressT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CancelMetadataTransferJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metadataTransferJobId;

  Aws::String m_arn;

  Aws::Utils::DateTime m_updateDateTime{};

  MetadataTransferJobStatus m_status;

  MetadataTransferJobProgress m_progress;

  Aws::String m_requestId;
  bool m_metadataTransferJobIdHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_updateDateTimeHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_progressHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
