﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecr/ECR_EXPORTS.h>
#include <aws/ecr/model/RegistryScanningConfiguration.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ECR {
namespace Model {
class GetRegistryScanningConfigurationResult {
 public:
  AWS_ECR_API GetRegistryScanningConfigurationResult() = default;
  AWS_ECR_API GetRegistryScanningConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ECR_API GetRegistryScanningConfigurationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The registry ID associated with the request.</p>
   */
  inline const Aws::String& GetRegistryId() const { return m_registryId; }
  template <typename RegistryIdT = Aws::String>
  void SetRegistryId(RegistryIdT&& value) {
    m_registryIdHasBeenSet = true;
    m_registryId = std::forward<RegistryIdT>(value);
  }
  template <typename RegistryIdT = Aws::String>
  GetRegistryScanningConfigurationResult& WithRegistryId(RegistryIdT&& value) {
    SetRegistryId(std::forward<RegistryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The scanning configuration for the registry.</p>
   */
  inline const RegistryScanningConfiguration& GetScanningConfiguration() const { return m_scanningConfiguration; }
  template <typename ScanningConfigurationT = RegistryScanningConfiguration>
  void SetScanningConfiguration(ScanningConfigurationT&& value) {
    m_scanningConfigurationHasBeenSet = true;
    m_scanningConfiguration = std::forward<ScanningConfigurationT>(value);
  }
  template <typename ScanningConfigurationT = RegistryScanningConfiguration>
  GetRegistryScanningConfigurationResult& WithScanningConfiguration(ScanningConfigurationT&& value) {
    SetScanningConfiguration(std::forward<ScanningConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetRegistryScanningConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registryId;

  RegistryScanningConfiguration m_scanningConfiguration;

  Aws::String m_requestId;
  bool m_registryIdHasBeenSet = false;
  bool m_scanningConfigurationHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECR
}  // namespace Aws
